
<style>
.card {
  border-radius: 12px;
  transition: transform .2s ease, box-shadow .2s ease;
}
.card:hover {
  transform: translateY(-4px);
  box-shadow: 0 12px 30px rgba(0,0,0,.15);
}
.btn {
  transition: all .2s ease;
}
.btn:hover {
  transform: translateY(-1px);
}
.table-hover tbody tr {
  transition: background-color .15s ease;
}
.fade-in {
  animation: fadeIn .4s ease-in-out;
}
@keyframes fadeIn {
  from {opacity:0; transform: translateY(6px);}
  to {opacity:1; transform:none;}
}
</style>

<div class="container my-4">
<div class="card shadow-sm fade-in">
<div class="card-body">
<?php

/* @var $this yii\web\View */
/* @var $model app\models\Application */

use yii\helpers\Html;
use yii\helpers\Url;

$this->title = 'Заявка #' . $model->id;
$this->params['breadcrumbs'][] = ['label' => 'Мои заявки', 'url' => ['applications']];
$this->params['breadcrumbs'][] = $this->title;
?>

    <div class="site-view-application">
        <div class="row">
            <div class="col-lg-8">
                <div class="card shadow mb-4">
                    <div class="card-header bg-primary text-white d-flex justify-content-between align-items-center">
                        <h3 class="mb-0"><?= Html::encode($this->title) ?></h3>
                        <span class="badge bg-<?= $model->status === 'new' ? 'warning' :
                            ($model->status === 'approved' ? 'success' : 'info') ?> fs-6">
                        <?= $model->getStatusLabel() ?>
                    </span>
                    </div>
                    <div class="card-body">
                        <div class="row">
                            <div class="col-md-6">
                                <div class="card mb-3">
                                    <div class="card-header bg-light">
                                        <h5 class="mb-0"><i class="fas fa-dice me-2"></i>Информация об игре</h5>
                                    </div>
                                    <div class="card-body">
                                        <table class="table table-borderless">
                                            <tr>
                                                <th width="40%">Игра:</th>
                                                <td><?= Html::encode($model->game_name) ?></td>
                                            </tr>
                                            <tr>
                                                <th>Категория:</th>
                                                <td><?= $model->game_category ?></td>
                                            </tr>
                                            <tr>
                                                <th>Дата:</th>
                                                <td><?= Yii::$app->formatter->asDate($model->date) ?></td>
                                            </tr>
                                            <tr>
                                                <th>Время:</th>
                                                <td><?= $model->start_time ?></td>
                                            </tr>
                                            <tr>
                                                <th>Адрес:</th>
                                                <td><?= Html::encode($model->address) ?></td>
                                            </tr>
                                            <tr>
                                                <th>Стоимость:</th>
                                                <td><?= $model->price ?> ₽</td>
                                            </tr>
                                        </table>
                                    </div>
                                </div>
                            </div>

                            <div class="col-md-6">
                                <div class="card mb-3">
                                    <div class="card-header bg-light">
                                        <h5 class="mb-0"><i class="fas fa-user me-2"></i>Ваши данные</h5>
                                    </div>
                                    <div class="card-body">
                                        <table class="table table-borderless">
                                            <tr>
                                                <th width="40%">ФИО:</th>
                                                <td><?= Html::encode($model->full_name) ?></td>
                                            </tr>
                                            <tr>
                                                <th>Телефон:</th>
                                                <td><?= Html::encode($model->phone) ?></td>
                                            </tr>
                                            <tr>
                                                <th>Email:</th>
                                                <td><?= Html::encode($model->email) ?></td>
                                            </tr>
                                            <tr>
                                                <th>Уровень игры:</th>
                                                <td><?= $model->getPlayerLevelLabel() ?></td>
                                            </tr>
                                            <tr>
                                                <th>Способ оплаты:</th>
                                                <td><?= $model->getPaymentMethodLabel() ?></td>
                                            </tr>
                                            <tr>
                                                <th>Согласие на обработку данных:</th>
                                                <td>
                                                    <?= $model->personal_data_agreement ?
                                                        '<span class="badge bg-success"><i class="fas fa-check"></i> Да</span>' :
                                                        '<span class="badge bg-danger"><i class="fas fa-times"></i> Нет</span>' ?>
                                                </td>
                                            </tr>
                                        </table>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="card">
                            <div class="card-header bg-light">
                                <h5 class="mb-0"><i class="fas fa-info-circle me-2"></i>Статус заявки</h5>
                            </div>
                            <div class="card-body">
                                <?php if ($model->status === 'new'): ?>
                                    <div class="alert alert-warning">
                                        <h5><i class="fas fa-clock me-2"></i>На рассмотрении</h5>
                                        <p class="mb-0">Ваша заявка находится на рассмотрении администратора.
                                            Обычно это занимает не более 24 часов.</p>
                                    </div>
                                <?php elseif ($model->status === 'approved'): ?>
                                    <div class="alert alert-success">
                                        <h5><i class="fas fa-check-circle me-2"></i>Заявка одобрена</h5>
                                        <p class="mb-0">Ваша заявка одобрена! Ждем вас на игре в указанное время и месте.</p>
                                    </div>
                                <?php else: ?>
                                    <div class="alert alert-info">
                                        <h5><i class="fas fa-flag-checkered me-2"></i>Игра завершена</h5>
                                        <p class="mb-0">Игра завершена. Надеемся, вам понравилось!</p>
                                    </div>
                                <?php endif; ?>

                                <div class="text-center mt-4">
                                    <div class="row">
                                        <div class="col-md-4">
                                            <div class="text-muted">
                                                <i class="fas fa-calendar-plus fa-2x mb-2"></i>
                                                <p class="mb-0"><strong>Создана</strong></p>
                                                <p class="mb-0"><?= Yii::$app->formatter->asDate($model->created_at) ?></p>
                                                <small><?= Yii::$app->formatter->asTime($model->created_at) ?></small>
                                            </div>
                                        </div>
                                        <div class="col-md-4">
                                            <div class="text-muted">
                                                <i class="fas fa-sync-alt fa-2x mb-2"></i>
                                                <p class="mb-0"><strong>Обновлена</strong></p>
                                                <p class="mb-0"><?= Yii::$app->formatter->asDate($model->updated_at) ?></p>
                                                <small><?= Yii::$app->formatter->asTime($model->updated_at) ?></small>
                                            </div>
                                        </div>
                                        <div class="col-md-4">
                                            <div class="text-muted">
                                                <i class="fas fa-gamepad fa-2x mb-2"></i>
                                                <p class="mb-0"><strong>Статус</strong></p>
                                                <p class="mb-0"><?= $model->getStatusLabel() ?></p>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <div class="col-lg-4">
                <div class="card shadow mb-4">
                    <div class="card-header bg-info text-white">
                        <h5 class="mb-0">Действия</h5>
                    </div>
                    <div class="card-body">
                        <div class="d-grid gap-2">
                            <a href="<?= Url::to(['site/applications']) ?>" class="btn btn-outline-primary">
                                <i class="fas fa-arrow-left me-2"></i>Вернуться к списку
                            </a>
                            <a href="<?= Url::to(['site/create-application']) ?>" class="btn btn-primary btn-lg">
                                <i class="fas fa-plus me-2"></i>Создать новую заявку
                            </a>

                            <?php if ($model->status === 'completed'): ?>
                                <button type="button" class="btn btn-warning" id="add-review-page-btn">
                                    <i class="fas fa-star me-2"></i>Оставить отзыв
                                </button>
                            <?php endif; ?>

                            <?php if ($model->status === 'new'): ?>
                                <button type="button" class="btn btn-outline-danger" id="cancel-application-btn">
                                    <i class="fas fa-times me-2"></i>Отменить заявку
                                </button>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>

                <div class="card shadow">
                    <div class="card-header bg-success text-white">
                        <h5 class="mb-0">Контакты</h5>
                    </div>
                    <div class="card-body">
                        <p>Если у вас есть вопросы по заявке:</p>
                        <ul class="list-unstyled">
                            <li class="mb-2">
                                <i class="fas fa-phone me-2 text-success"></i>
                                <strong>Телефон:</strong> +7 (495) 123-45-67
                            </li>
                            <li class="mb-2">
                                <i class="fas fa-envelope me-2 text-success"></i>
                                <strong>Email:</strong> info@nastolka.ru
                            </li>
                            <li>
                                <i class="fas fa-clock me-2 text-success"></i>
                                <strong>Время работы:</strong> 10:00 - 22:00
                            </li>
                        </ul>
                    </div>
                </div>
            </div>
        </div>
    </div>

<?php
$js = <<<JS
$(document).ready(function() {
    // Отмена заявки
    $('#cancel-application-btn').on('click', function() {
        if (confirm('Вы уверены, что хотите отменить эту заявку?')) {
            $.ajax({
                url: '/site/cancel-application?id=$model->id',
                type: 'POST',
                data: {
                    _csrf: yii.getCsrfToken()
                },
                success: function(response) {
                    if (response.success) {
                        alert('Заявка отменена');
                        window.location.href = '/site/applications';
                    } else {
                        alert('Ошибка: ' + response.message);
                    }
                }
            });
        }
    });
    
    // Оставить отзыв (для страницы)
    $('#add-review-page-btn').on('click', function() {
        // Здесь можно добавить код для формы отзыва
        alert('Форма отзыва будет открыта в модальном окне');
    });
});
JS;
$this->registerJs($js);
?>
</div>
</div>
</div>