<style>
.card {
  border-radius: 12px;
  transition: transform .2s ease, box-shadow .2s ease;
}
.card:hover {
  transform: translateY(-4px);
  box-shadow: 0 12px 30px rgba(0,0,0,.15);
}
.btn {
  transition: all .2s ease;
}
.btn:hover {
  transform: translateY(-1px);
}
.table-hover tbody tr {
  transition: background-color .15s ease;
}
.fade-in {
  animation: fadeIn .4s ease-in-out;
}
@keyframes fadeIn {
  from {opacity:0; transform: translateY(6px);}
  to {opacity:1; transform:none;}
}
</style>

<div class="container my-4">
<div class="card shadow-sm fade-in">
<div class="card-body">
<?php

/* @var $this yii\web\View */
/* @var $model app\models\User */

use yii\helpers\Html;
use yii\widgets\ActiveForm;
use yii\helpers\Url;

$this->title = 'Авторизация';
$this->params['breadcrumbs'][] = $this->title;
?>

    <div class="site-login">
        <div class="row justify-content-center">
            <div class="col-md-5">
                <div class="card shadow">
                    <div class="card-header bg-primary text-white">
                        <h2 class="mb-0 text-center"><?= Html::encode($this->title) ?></h2>
                    </div>

                    <div class="card-body">
                        <?php $form = ActiveForm::begin([
                            'id' => 'login-form',
                            'enableClientValidation' => false,
                            'fieldConfig' => [
                                'template' => "{label}\n{input}\n{error}",
                                'labelOptions' => ['class' => 'form-label'],
                                'inputOptions' => ['class' => 'form-control'],
                                'errorOptions' => ['class' => 'invalid-feedback'],
                            ],
                        ]); ?>

                        <?= $form->field($model, 'phone')
                            ->textInput(['autofocus' => true, 'placeholder' => '8(999)999-99-99'])
                            ->label('Телефон') ?>

                        <?= $form->field($model, 'password')
                            ->passwordInput(['placeholder' => 'Введите ваш пароль'])
                            ->label('Пароль') ?>

                        <?= $form->field($model, 'rememberMe')->checkbox([
                            'template' => "<div class=\"form-check\">\n{input} {label}\n{error}\n</div>",
                            'labelOptions' => ['class' => 'form-check-label'],
                        ]) ?>

                        <div class="form-group mt-4">
                            <?= Html::submitButton('Войти', [
                                'class' => 'btn btn-primary btn-lg w-100',
                                'name' => 'login-button'
                            ]) ?>
                        </div>

                        <?php ActiveForm::end(); ?>

                        <hr class="my-4">

                        <div class="text-center">
                            <p class="mb-2">Еще не зарегистрированы?</p>
                            <?= Html::a('Зарегистрироваться', ['site/register'], ['class' => 'btn btn-outline-primary']) ?>
                        </div>
                    </div>
                </div>

                <!-- Информация для тестирования -->
                <div class="card mt-4 border-info">
                    <div class="card-header bg-info text-white">
                        <h5 class="mb-0 text-center">Тестовые данные</h5>
                    </div>
                    <div class="card-body">
                        <p class="mb-2"><strong>Администратор:</strong></p>
                        <p class="mb-1">Телефон: 8(999)999-99-99</p>
                        <p class="mb-3">Пароль: organizator</p>

                        <div class="d-grid gap-2">
                            <button id="demo-admin" class="btn btn-sm btn-outline-info">
                                <i class="fas fa-user-cog me-1"></i>Заполнить данные администратора
                            </button>
                            <button id="demo-user" class="btn btn-sm btn-outline-info">
                                <i class="fas fa-user me-1"></i>Заполнить данные пользователя
                            </button>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

<?php
$js = <<<JS
$(document).ready(function() {
    // Форматирование телефона при вводе
    $('#user-phone').on('input', function() {
        var phone = $(this).val().replace(/\D/g, '');
        
        if (phone.length === 11 && phone[0] === '8') {
            phone = phone.replace(/(\d{1})(\d{3})(\d{3})(\d{2})(\d{2})/, '$1($2)$3-$4-$5');
            $(this).val(phone);
        }
    });
    
    // Автозаполнение для демо
    $('#demo-admin').on('click', function(e) {
        e.preventDefault();
        $('#user-phone').val('8(999)999-99-99');
        $('#user-password').val('organizator');
        $('#user-rememberme').prop('checked', true);
    });
    
    $('#demo-user').on('click', function(e) {
        e.preventDefault();
        // Если есть тестовый пользователь
        $('#user-phone').val('8(999)123-45-67');
        $('#user-password').val('password123');
        $('#user-rememberme').prop('checked', true);
    });
});
JS;
$this->registerJs($js);
?>
</div>
</div>
</div>