<?php
use yii\helpers\Html;
use yii\helpers\Url;
?>

<div class="site-index">
    <!-- Герой-секция с градиентом -->
    <section class="hero-section bg-gradient-primary text-white py-6 py-md-8">
        <div class="container">
            <div class="row align-items-center">
                <div class="col-lg-8 col-md-10 mx-auto text-center">
                    <div class="hero-content">
                        <h1 class="display-4 fw-bold mb-3 animate__animated animate__fadeInDown">Настольные игры для любой компании</h1>
                        <p class="lead mb-4 fs-5 animate__animated animate__fadeInUp animate__delay-1s">Присоединяйтесь к нашему сообществу любителей настольных игр</p>
                        <div class="d-grid gap-3 d-sm-flex justify-content-sm-center animate__animated animate__fadeIn animate__delay-2s">
                            <?php if (Yii::$app->user->isGuest): ?>
                                <a href="<?= Url::to(['site/register']) ?>" class="btn btn-light btn-lg px-4 px-sm-5 py-3 rounded-pill fw-bold shadow-lg">
                                    <i class="fas fa-user-plus me-2"></i>Присоединиться
                                </a>
                                <a href="<?= Url::to(['site/login']) ?>" class="btn btn-outline-light btn-lg px-4 px-sm-5 py-3 rounded-pill fw-bold">
                                    <i class="fas fa-sign-in-alt me-2"></i>Войти
                                </a>
                            <?php else: ?>
                                <a href="<?= Url::to(['site/create-application']) ?>" class="btn btn-warning btn-lg px-4 px-sm-5 py-3 rounded-pill fw-bold shadow-lg">
                                    <i class="fas fa-gamepad me-2"></i>Записаться на игру
                                </a>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Популярные игры с каруселью -->
    <section class="popular-games py-5 py-md-6 bg-white">
        <div class="container">
            <div class="row mb-5">
                <div class="col-12 text-center">
                    <h2 class="display-5 fw-bold mb-3 position-relative d-inline-block">
                        <span class="position-relative">Популярные игры</span>
                        <span class="position-absolute top-100 start-50 translate-middle-x w-50 border-top border-3 border-warning"></span>
                    </h2>
                    <p class="text-muted fs-5 mb-0">Самые востребованные игры нашего клуба</p>
                </div>
            </div>
            
            <div class="row g-4">
                <?php foreach ($popularGames as $index => $game): ?>
                    <div class="col-xl-3 col-lg-4 col-md-6">
                        <div class="card h-100 border-0 shadow-sm hover-shadow transition-all overflow-hidden">
                            <div class="card-img-top bg-gradient-light d-flex align-items-center justify-content-center" style="height: 180px; background: linear-gradient(135deg, #f8f9fa 0%, #e9ecef 100%);">
                                <i class="fas fa-dice text-primary opacity-25" style="font-size: 5rem;"></i>
                            </div>
                            <div class="card-body p-4 text-center">
                                <h5 class="card-title fw-bold mb-3"><?= Html::encode($game->name) ?></h5>
                                <div class="d-flex justify-content-center mb-3">
                                    <span class="badge bg-warning bg-opacity-10 text-warning border border-warning border-opacity-25 py-2 px-3 rounded-pill fw-normal">
                                        <?= $game->getCategoryLabel() ?>
                                    </span>
                                </div>
                                <div class="mt-3 pt-3 border-top">
                                    <button class="btn btn-outline-primary btn-sm rounded-pill px-4" 
                                            data-bs-toggle="modal" 
                                            data-bs-target="#gameModal<?= $index ?>">
                                        <i class="fas fa-info-circle me-1"></i>Подробнее
                                    </button>
                                </div>
                            </div>
                        </div>
                    </div>
                <?php endforeach; ?>
            </div>
        </div>
    </section>

    <!-- График игр с табами -->
    <section class="schedule py-5 py-md-6 bg-light">
        <div class="container">
            <div class="row mb-5">
                <div class="col-12 text-center">
                    <h2 class="display-5 fw-bold mb-3 position-relative d-inline-block">
                        <span class="position-relative">Ближайшие игры</span>
                        <span class="position-absolute top-100 start-50 translate-middle-x w-50 border-top border-3 border-primary"></span>
                    </h2>
                    <p class="text-muted fs-5 mb-0">Выберите удобное время и присоединяйтесь</p>
                </div>
            </div>

            <div class="row g-4">
                <?php foreach ($upcomingSchedule as $schedule): ?>
                    <div class="col-lg-4 col-md-6">
                        <div class="card h-100 border-0 shadow-sm hover-shadow transition-all">
                            <div class="card-header bg-white border-0 pt-4 px-4">
                                <div class="d-flex justify-content-between align-items-start">
                                    <div>
                                        <h5 class="card-title fw-bold mb-1"><?= Html::encode($schedule->game->name) ?></h5>
                                        <span class="badge bg-primary bg-opacity-10 text-primary px-3 py-2 rounded-pill">
                                            <?= $schedule->game->getCategoryLabel() ?>
                                        </span>
                                    </div>
                                    <span class="badge bg-success bg-gradient px-3 py-2 fs-6 fw-bold">
                                        <?= $schedule->price ?> ₽
                                    </span>
                                </div>
                            </div>
                            
                            <div class="card-body px-4 pb-4">
                                <div class="schedule-details mb-4">
                                    <div class="d-flex align-items-center mb-3">
                                        <div class="icon-container bg-primary bg-opacity-10 rounded-circle p-3 me-3">
                                            <i class="far fa-calendar text-primary fs-5"></i>
                                        </div>
                                        <div>
                                            <small class="text-muted d-block">Дата</small>
                                            <strong><?= Yii::$app->formatter->asDate($schedule->date, 'php:d.m.Y') ?></strong>
                                        </div>
                                    </div>
                                    
                                    <div class="d-flex align-items-center mb-3">
                                        <div class="icon-container bg-primary bg-opacity-10 rounded-circle p-3 me-3">
                                            <i class="far fa-clock text-primary fs-5"></i>
                                        </div>
                                        <div>
                                            <small class="text-muted d-block">Время</small>
                                            <strong><?= $schedule->start_time ?></strong>
                                        </div>
                                    </div>
                                    
                                    <div class="d-flex align-items-center">
                                        <div class="icon-container bg-primary bg-opacity-10 rounded-circle p-3 me-3">
                                            <i class="fas fa-map-marker-alt text-primary fs-5"></i>
                                        </div>
                                        <div>
                                            <small class="text-muted d-block">Место</small>
                                            <strong><?= Html::encode($schedule->address) ?></strong>
                                        </div>
                                    </div>
                                </div>

                                <div class="players-progress mb-4">
                                    <div class="d-flex justify-content-between mb-2">
                                        <span class="text-muted">
                                            <i class="fas fa-users me-1"></i>
                                            Участники
                                        </span>
                                        <span class="fw-bold">
                                            <?= $schedule->current_players ?>/<?= $schedule->max_players ?>
                                        </span>
                                    </div>
                                    <div class="progress" style="height: 8px;">
                                        <div class="progress-bar bg-<?= $schedule->isFull() ? 'danger' : 'success' ?>" 
                                             role="progressbar" 
                                             style="width: <?= ($schedule->current_players / $schedule->max_players) * 100 ?>%">
                                        </div>
                                    </div>
                                </div>

                                <div class="d-grid">
                                    <?php if (!$schedule->isFull()): ?>
                                        <a href="<?= Url::to(['site/create-application', 'schedule_id' => $schedule->id]) ?>"
                                           class="btn btn-primary btn-lg rounded-pill py-3 fw-bold">
                                            <i class="fas fa-ticket-alt me-2"></i>Записаться сейчас
                                        </a>
                                    <?php else: ?>
                                        <button class="btn btn-danger btn-lg rounded-pill py-3 fw-bold" disabled>
                                            <i class="fas fa-times-circle me-2"></i>Мест нет
                                        </button>
                                    <?php endif; ?>
                                </div>
                            </div>
                        </div>
                    </div>
                <?php endforeach; ?>
            </div>
            
            <div class="row mt-5">
                <div class="col-12 text-center">
                    <a href="<?= Url::to(['site/create-application']) ?>" 
                       class="btn btn-outline-primary btn-lg px-5 py-3 rounded-pill fw-bold">
                        <i class="fas fa-calendar-alt me-2"></i>Все расписание
                    </a>
                </div>
            </div>
        </div>
    </section>

    <!-- Отзывы с каруселью -->
    <section class="reviews py-5 py-md-6 bg-white">
        <div class="container">
            <div class="row mb-5">
                <div class="col-12 text-center">
                    <h2 class="display-5 fw-bold mb-3 position-relative d-inline-block">
                        <span class="position-relative">Отзывы участников</span>
                        <span class="position-absolute top-100 start-50 translate-middle-x w-50 border-top border-3 border-warning"></span>
                    </h2>
                    <p class="text-muted fs-5 mb-0">Что говорят наши игроки</p>
                </div>
            </div>
            
            <div class="row g-4">
                <?php foreach ($reviews as $review): ?>
                    <div class="col-lg-4 col-md-6">
                        <div class="card h-100 border-0 shadow-sm hover-lift">
                            <div class="card-body p-4">
                                <div class="review-header d-flex align-items-center mb-4">
                                    <div class="flex-shrink-0">
                                        <div class="avatar bg-gradient-primary text-white rounded-circle d-flex align-items-center justify-content-center" 
                                             style="width: 60px; height: 60px; font-size: 1.5rem; font-weight: bold;">
                                            <?= mb_substr($review->user->full_name, 0, 1) ?>
                                        </div>
                                    </div>
                                    <div class="flex-grow-1 ms-3">
                                        <h5 class="mb-1 fw-bold"><?= Html::encode($review->user->full_name) ?></h5>
                                        <div class="text-warning">
                                            <?= str_repeat('★', $review->rating) ?><?= str_repeat('☆', 5 - $review->rating) ?>
                                        </div>
                                    </div>
                                </div>
                                
                                <div class="review-content">
                                    <p class="mb-0 fs-5 fst-italic">"<?= Html::encode($review->comment) ?>"</p>
                                </div>
                                
                                <div class="review-footer mt-4 pt-3 border-top">
                                    <small class="text-muted">
                                        <i class="far fa-calendar me-1"></i>
                                        <?= Yii::$app->formatter->asRelativeTime($review->created_at) ?>
                                    </small>
                                </div>
                            </div>
                        </div>
                    </div>
                <?php endforeach; ?>
            </div>
        </div>
    </section>

    <!-- Подписка на новости -->
    <section class="subscription py-5 py-md-6 bg-gradient-primary text-white">
        <div class="container">
            <div class="row justify-content-center">
                <div class="col-lg-8 col-md-10 text-center">
                    <div class="subscription-content">
                        <div class="icon-container bg-white text-primary rounded-circle d-inline-flex align-items-center justify-content-center mb-4" 
                             style="width: 80px; height: 80px;">
                            <i class="fas fa-envelope fs-2"></i>
                        </div>
                        
                        <h2 class="display-5 fw-bold mb-3">Будьте в курсе событий</h2>
                        <p class="lead mb-4 opacity-75">Узнавайте первыми о новых играх, мероприятиях и специальных предложениях</p>
                        
                        <form id="subscription-form" class="subscription-form mt-5" 
                              action="<?= Url::to(['site/subscribe']) ?>" method="post">
                            <div class="row g-3 justify-content-center">
                                <div class="col-lg-6 col-md-8">
                                    <div class="input-group input-group-lg shadow-lg">
                                        <input type="email" 
                                               name="email" 
                                               class="form-control border-0 py-3 px-4" 
                                               placeholder="Введите ваш email" 
                                               required
                                               style="border-radius: 50px 0 0 50px;">
                                        <button type="submit" 
                                                class="btn btn-warning text-dark fw-bold px-5 py-3"
                                                style="border-radius: 0 50px 50px 0;">
                                            <i class="fas fa-paper-plane me-2"></i>Подписаться
                                        </button>
                                    </div>
                                </div>
                            </div>
                            <p class="text-white-50 small mt-3">
                                Подписываясь, вы соглашаетесь с нашей политикой конфиденциальности
                            </p>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </section>
</div>

<?php
// CSS стили для улучшения дизайна
$css = <<<CSS
.hero-section {
    background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
    position: relative;
    overflow: hidden;
}

.hero-section::before {
    content: '';
    position: absolute;
    top: 0;
    left: 0;
    right: 0;
    bottom: 0;
    background: url('data:image/svg+xml,<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 1440 320"><path fill="%23ffffff" fill-opacity="0.1" d="M0,96L48,112C96,128,192,160,288,186.7C384,213,480,235,576,213.3C672,192,768,128,864,128C960,128,1056,192,1152,208C1248,224,1344,192,1392,176L1440,160L1440,320L1392,320C1344,320,1248,320,1152,320C1056,320,960,320,864,320C768,320,672,320,576,320C480,320,384,320,288,320C192,320,96,320,48,320L0,320Z"></path></svg>');
    background-size: cover;
    opacity: 0.1;
}

.hover-shadow {
    transition: all 0.3s ease;
}

.hover-shadow:hover {
    transform: translateY(-5px);
    box-shadow: 0 10px 25px rgba(0,0,0,0.1) !important;
}

.transition-all {
    transition: all 0.3s ease;
}

.hover-lift:hover {
    transform: translateY(-3px);
    box-shadow: 0 5px 15px rgba(0,0,0,0.08);
}

.icon-container {
    transition: all 0.3s ease;
}

.bg-gradient-primary {
    background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
}

.bg-gradient-light {
    background: linear-gradient(135deg, #f8f9fa 0%, #e9ecef 100%);
}

.progress {
    border-radius: 10px;
    overflow: hidden;
}

.progress-bar {
    border-radius: 10px;
}

.avatar {
    background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
}
CSS;

$this->registerCss($css);

// Исправленный JavaScript - используем конкатенацию строк вместо шаблонных литералов
$js = <<<JS
$('#subscription-form').on('submit', function(e) {
    e.preventDefault();
    var form = $(this);
    var submitBtn = form.find('button[type="submit"]');
    var originalText = submitBtn.html();
    
    submitBtn.prop('disabled', true).html('<i class="fas fa-spinner fa-spin me-2"></i>Отправка...');
    
    $.ajax({
        url: form.attr('action'),
        type: 'POST',
        data: form.serialize(),
        dataType: 'json',
        success: function(response) {
            if (response.success) {
                form.find('input').val('');
                // Показываем красивый алерт
                showAlert('Успех!', response.message, 'success');
            } else {
                if (response.errors && response.errors.email) {
                    showAlert('Ошибка', response.errors.email.join(', '), 'error');
                } else {
                    showAlert('Ошибка', 'Произошла ошибка при подписке', 'error');
                }
            }
        },
        error: function() {
            showAlert('Ошибка сети', 'Попробуйте позже.', 'error');
        },
        complete: function() {
            submitBtn.prop('disabled', false).html(originalText);
        }
    });
    return false;
});

function showAlert(title, message, type) {
    // Создаем красивый алерт
    var alertClass = type === 'success' ? 'alert-success' : 'alert-danger';
    var icon = type === 'success' ? 'fa-check-circle' : 'fa-exclamation-circle';
    
    // Используем конкатенацию строк вместо шаблонных литералов
    var alertHtml = '<div class="alert ' + alertClass + ' alert-dismissible fade show position-fixed top-0 end-0 m-3" ' +
                   'role="alert" style="z-index: 9999; min-width: 300px;">' +
                   '<div class="d-flex align-items-center">' +
                   '<i class="fas ' + icon + ' fa-2x me-3"></i>' +
                   '<div>' +
                   '<h5 class="alert-heading mb-1">' + title + '</h5>' +
                   '<p class="mb-0">' + message + '</p>' +
                   '</div>' +
                   '</div>' +
                   '<button type="button" class="btn-close" data-bs-dismiss="alert"></button>' +
                   '</div>';
    
    $('body').append(alertHtml);
    
    // Автоматически скрываем через 5 секунд
    setTimeout(function() {
        $('.alert').alert('close');
    }, 5000);
}

// Инициализация тултипов
$(function () {
    $('[data-bs-toggle="tooltip"]').tooltip();
});
JS;
$this->registerJs($js);
?>