
<style>
.card {
  border-radius: 12px;
  transition: transform .2s ease, box-shadow .2s ease;
}
.card:hover {
  transform: translateY(-4px);
  box-shadow: 0 12px 30px rgba(0,0,0,.15);
}
.btn {
  transition: all .2s ease;
}
.btn:hover {
  transform: translateY(-1px);
}
.table-hover tbody tr {
  transition: background-color .15s ease;
}
.fade-in {
  animation: fadeIn .4s ease-in-out;
}
@keyframes fadeIn {
  from {opacity:0; transform: translateY(6px);}
  to {opacity:1; transform:none;}
}
</style>

<div class="container my-4">
<div class="card shadow-sm fade-in">
<div class="card-body">
<?php

/* @var $this yii\web\View */
/* @var $name string */
/* @var $message string */
/* @var $exception Exception */

use yii\helpers\Html;

$this->title = $name;
?>

<div class="site-error">
    <div class="row justify-content-center">
        <div class="col-md-8">
            <div class="card shadow">
                <div class="card-body text-center py-5">
                    <i class="fas fa-exclamation-triangle fa-5x text-warning mb-4"></i>
                    <h1><?= Html::encode($this->title) ?></h1>

                    <div class="alert alert-danger mt-4">
                        <?= nl2br(Html::encode($message)) ?>
                    </div>

                    <p class="lead mt-4">
                        Вышеуказанная ошибка произошла, когда веб-сервер обрабатывал ваш запрос.
                    </p>

                    <p class="mb-4">
                        Пожалуйста, свяжитесь с нами, если вы считаете, что это ошибка сервера. Спасибо.
                    </p>

                    <div class="mt-4">
                        <a href="<?= Yii::$app->homeUrl ?>" class="btn btn-primary btn-lg btn-lg me-3">
                            <i class="fas fa-home me-2"></i>На главную
                        </a>
                        <a href="javascript:history.back()" class="btn btn-outline-primary btn-lg">
                            <i class="fas fa-arrow-left me-2"></i>Назад
                        </a>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
</div>
</div>
</div>