
<style>
.card {
  border-radius: 12px;
  transition: transform .2s ease, box-shadow .2s ease;
}
.card:hover {
  transform: translateY(-4px);
  box-shadow: 0 12px 30px rgba(0,0,0,.15);
}
.btn {
  transition: all .2s ease;
}
.btn:hover {
  transform: translateY(-1px);
}
.table-hover tbody tr {
  transition: background-color .15s ease;
}
.fade-in {
  animation: fadeIn .4s ease-in-out;
}
@keyframes fadeIn {
  from {opacity:0; transform: translateY(6px);}
  to {opacity:1; transform:none;}
}
</style>

<div class="container my-4">
<div class="card shadow-sm fade-in">
<div class="card-body">
<?php

/* @var $this yii\web\View */
/* @var $gamesByCategory array */

use yii\helpers\Html;
use yii\helpers\Url;

$this->title = 'Каталог настольных игр';
$this->params['breadcrumbs'][] = $this->title;
?>

<div class="site-catalog">
    <div class="catalog-header">
        <h1 class="text-center mb-4"><?= Html::encode($this->title) ?></h1>
        <p class="text-center text-muted mb-5">Выберите интересующую категорию или найдите свою игру</p>
    </div>

    <div class="row">
        <div class="col-lg-3">
            <!-- Фильтр по категориям -->
            <div class="card filter-card shadow-sm fade-in mb-4">
                <div class="card-header">
                    <h5 class="mb-0"><i class="fas fa-tags me-2"></i>Категории игр</h5>
                </div>
                <div class="card-body p-0">
                    <div class="list-group list-group-flush">
                        <?php foreach ($gamesByCategory as $category => $games): ?>
                            <a href="#category-<?= $category ?>" 
                               class="list-group-item list-group-item-action d-flex justify-content-between align-items-center">
                                <div class="d-flex align-items-center">
                                    <div class="category-indicator me-3 bg-<?= $category ?>"></div>
                                    <span><?= \app\models\Game::getCategories()[$category] ?></span>
                                </div>
                                <span class="badge rounded-pill"><?= count($games) ?></span>
                            </a>
                        <?php endforeach; ?>
                    </div>
                </div>
            </div>

            <!-- Информация о записи -->
            <div class="card info-card shadow-sm fade-in">
                <div class="card-body text-center">
                    <div class="info-icon mb-3">
                        <i class="fas fa-calendar-alt fa-3x"></i>
                    </div>
                    <h5 class="card-title">Хотите поиграть?</h5>
                    <p class="card-text">Выберите игру из каталога и запишитесь на ближайшую сессию.</p>
                    <a href="<?= Url::to(['site/create-application']) ?>" class="btn btn-primary btn-lg w-100">
                        <i class="fas fa-calendar-plus me-2"></i>Записаться на игру
                    </a>
                </div>
            </div>
            
            <!-- Статистика -->
            <div class="stats-card mt-4">
                <div class="stat-item">
                    <div class="stat-value"><?= array_sum(array_map('count', $gamesByCategory)) ?></div>
                    <div class="stat-label">Всего игр</div>
                </div>
                <div class="stat-item">
                    <div class="stat-value"><?= count($gamesByCategory) ?></div>
                    <div class="stat-label">Категорий</div>
                </div>
            </div>
        </div>

        <div class="col-lg-9">
            <!-- Каталог игр по категориям -->
            <?php foreach ($gamesByCategory as $category => $games): ?>
                <div id="category-<?= $category ?>" class="category-section mb-5">
                    <div class="category-header mb-4">
                        <div class="d-flex align-items-center">
                            <div class="category-icon me-3">
                                <i class="fas fa-<?= $category === 'classic' ? 'chess' :
                                    ($category === 'card' ? 'heart' :
                                        ($category === 'economic' ? 'chart-line' :
                                            ($category === 'strategy' ? 'brain' : 'child'))) ?> fa-2x"></i>
                            </div>
                            <div class="flex-grow-1">
                                <h2 class="category-title mb-0"><?= \app\models\Game::getCategories()[$category] ?></h2>
                                <small class="text-muted"><?= count($games) ?> игр в категории</small>
                            </div>
                            <span class="games-count"><?= count($games) ?></span>
                        </div>
                        <div class="category-line mt-3"></div>
                    </div>

                    <div class="row">
                        <?php foreach ($games as $game): ?>
                            <div class="col-md-6 col-lg-4 mb-4">
                                <div class="card game-card h-100">
                                    <div class="card-header">
                                        <div class="game-icon">
                                            <i class="fas fa-dice"></i>
                                        </div>
                                        <?php if ($game->is_popular): ?>
                                            <div class="popular-tag">
                                                <i class="fas fa-star"></i> Популярная
                                            </div>
                                        <?php endif; ?>
                                    </div>
                                    <div class="card-body">
                                        <h4 class="card-title"><?= Html::encode($game->name) ?></h4>
                                        
                                        <?php if ($game->description): ?>
                                            <p class="card-text game-description"><?= Html::encode($game->description) ?></p>
                                        <?php endif; ?>
                                        
                                        <div class="game-tags mt-3">
                                            <span class="game-tag category">
                                                <?= \app\models\Game::getCategories()[$game->category] ?>
                                            </span>
                                        </div>
                                    </div>
                                    <div class="card-footer">
                                        <div class="d-flex justify-content-between">
                                            <a href="<?= Url::to(['site/create-application']) ?>"
                                               class="btn btn-primary btn-lg btn-sm">
                                                <i class="fas fa-calendar-plus me-1"></i>Записаться
                                            </a>
                                            <button class="btn btn-outline-secondary btn-sm game-info-btn"
                                                    data-name="<?= Html::encode($game->name) ?>"
                                                    data-category="<?= $game->getCategoryLabel() ?>">
                                                <i class="fas fa-info-circle me-1"></i>
                                            </button>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        <?php endforeach; ?>
                    </div>
                </div>
            <?php endforeach; ?>
            
            <!-- Призыв к действию -->
            <div class="cta-section mt-5">
                <div class="card cta-card">
                    <div class="card-body text-center">
                        <h3 class="mb-3">Нашли свою игру?</h3>
                        <p class="mb-4">Запишитесь прямо сейчас на ближайшую игровую сессию</p>
                        <a href="<?= Url::to(['site/create-application']) ?>" class="btn btn-lg btn-primary btn-lg">
                            <i class="fas fa-play-circle me-2"></i>Начать играть
                        </a>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<?php
$js = <<<JS
$(document).ready(function() {
    // Плавная прокрутка к категориям
    $('.list-group-item').on('click', function(e) {
        e.preventDefault();
        var target = $(this).attr('href');
        $('html, body').animate({
            scrollTop: $(target).offset().top - 20
        }, 500);
    });
    
    // Модальное окно с информацией об игре
    $('.game-info-btn').on('click', function() {
        var name = $(this).data('name');
        var category = $(this).data('category');
        
        var modalHtml = `
            <div class="modal fade" id="gameModal" tabindex="-1">
                <div class="modal-dialog">
                    <div class="modal-content">
                        <div class="modal-header">
                            <h5 class="modal-title">
                                <i class="fas fa-dice me-2"></i>\${name}
                            </h5>
                            <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                        </div>
                        <div class="modal-body">
                            <div class="game-modal-info">
                                <div class="row mb-3">
                                    <div class="col-6">
                                        <div class="info-label">Категория:</div>
                                        <div class="info-value fw-bold">\${category}</div>
                                    </div>
                                    <div class="col-6">
                                        <div class="info-label">Статус:</div>
                                        <div class="info-value">
                                            <span class="badge bg-success">
                                                <i class="fas fa-check me-1"></i>Доступно
                                            </span>
                                        </div>
                                    </div>
                                </div>
                                <p>Выберите удобное время для записи на игровую сессию.</p>
                            </div>
                        </div>
                        <div class="modal-footer">
                            <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Закрыть</button>
                            <a href="<?= Url::to(['site/create-application']) ?>" class="btn btn-primary btn-lg">
                                <i class="fas fa-calendar-plus me-1"></i>Записаться
                            </a>
                        </div>
                    </div>
                </div>
            </div>
        `;
        
        $('body').append(modalHtml);
        var modal = new bootstrap.Modal(document.getElementById('gameModal'));
        modal.show();
        
        $('#gameModal').on('hidden.bs.modal', function() {
            $(this).remove();
        });
    });
    
    // Подсветка активной категории при прокрутке
    $(window).on('scroll', function() {
        var scrollPos = $(document).scrollTop() + 100;
        
        $('.category-section').each(function() {
            var section = $(this);
            var sectionTop = section.offset().top;
            var sectionBottom = sectionTop + section.height();
            
            if (scrollPos >= sectionTop && scrollPos <= sectionBottom) {
                var categoryId = section.attr('id');
                $('.list-group-item').removeClass('active');
                $('a[href="#' + categoryId + '"]').addClass('active');
            }
        });
    });
    
    // Анимация карточек
    $('.game-card').hover(
        function() {
            $(this).addClass('hover');
        },
        function() {
            $(this).removeClass('hover');
        }
    );
});
JS;
$this->registerJs($js);

$css = <<<CSS
/* Основные стили */
.site-catalog {
    padding: 20px 0;
}

.catalog-header {
    margin-bottom: 40px;
}

.catalog-header h1 {
    color: #2c3e50;
    font-weight: 700;
    position: relative;
    display: inline-block;
}

.catalog-header h1::after {
    content: '';
    position: absolute;
    bottom: -10px;
    left: 50%;
    transform: translateX(-50%);
    width: 100px;
    height: 4px;
    background: linear-gradient(to right, #3498db, #2ecc71);
    border-radius: 2px;
}

/* Карточки фильтра */
.filter-card {
    border: none;
    border-radius: 12px;
    overflow: hidden;
    transition: transform 0.3s ease;
}

.filter-card:hover {
    transform: translateY(-2px);
}

.filter-card .card-header {
    background: linear-gradient(135deg, #4361ee 0%, #4361ee 100%);
    color: white;
    border: none;
    padding: 1.2rem;
    font-weight: 600;
}

.list-group-item {
    border: none;
    padding: 1rem 1.25rem;
    transition: all 0.3s ease;
    color: #4a5568;
}

.list-group-item:hover {
    background-color: #f7fafc;
    color: #667eea;
    transform: translateX(5px);
}

.list-group-item.active {
    background-color: #4361ee;
    color: white;
    border-left: 4px solid #4c51bf;
}

.list-group-item.active .badge {
    background-color: white !important;
    color: #667eea;
}

.category-indicator {
    width: 12px;
    height: 12px;
    border-radius: 50%;
}

.category-indicator.bg-classic { background-color: #3498db; }
.category-indicator.bg-card { background-color: #e74c3c; }
.category-indicator.bg-economic { background-color: #2ecc71; }
.category-indicator.bg-strategy { background-color: #9b59b6; }
.category-indicator.bg-family { background-color: #f39c12; }

.list-group-item .badge {
    background: linear-gradient(135deg, #4361ee 0%, #4361ee 100%);
    color: white;
    font-weight: 500;
    padding: 4px 10px;
}

/* Информационная карточка */
.info-card {
    border: none;
    border-radius: 12px;
    background: linear-gradient(135deg, #fdfcfb 0%, #e2d1c3 100%);
    overflow: hidden;
}

.info-icon {
    color: #667eea;
    opacity: 0.8;
}

.info-card .btn-primary btn-lg {
    background: linear-gradient(135deg, #4361ee 0%, #4361ee 100%);
    border: none;
    padding: 10px 20px;
    font-weight: 500;
}

/* Карточка статистики */
.stats-card {
    background: white;
    border-radius: 12px;
    padding: 20px;
    display: flex;
    justify-content: space-around;
    box-shadow: 0 2px 10px rgba(0,0,0,0.08);
}

.stat-item {
    text-align: center;
}

.stat-value {
    font-size: 2rem;
    font-weight: 700;
    background: linear-gradient(135deg, #4361ee 0%, #4361ee 100%);
    -webkit-background-clip: text;
    -webkit-text-fill-color: transparent;
    background-clip: text;
}

.stat-label {
    color: #718096;
    font-size: 0.9rem;
    margin-top: 5px;
}

/* Секции категорий */
.category-section {
    background: white;
    border-radius: 12px;
    padding: 25px;
    box-shadow: 0 4px 15px rgba(0,0,0,0.05);
    transition: box-shadow 0.3s ease;
}

.category-section:hover {
    box-shadow: 0 8px 25px rgba(0,0,0,0.1);
}

.category-header {
    margin-bottom: 30px;
}

.category-icon {
    width: 60px;
    height: 60px;
    display: flex;
    align-items: center;
    justify-content: center;
    background: linear-gradient(135deg, #4361ee 0%, #4361ee 100%);
    border-radius: 12px;
    color: white;
}

.category-title {
    color: #2d3748;
    font-weight: 700;
    font-size: 1.8rem;
}

.games-count {
    background: linear-gradient(135deg, #4361ee 0%, #4361ee 100%);
    color: white;
    padding: 8px 16px;
    border-radius: 20px;
    font-weight: 600;
    font-size: 1.1rem;
}

.category-line {
    height: 3px;
    background: linear-gradient(to right, transparent, #667eea, transparent);
    border-radius: 2px;
}

/* Карточки игр */
.game-card {
    border: none;
    border-radius: 12px;
    overflow: hidden;
    transition: all 0.4s cubic-bezier(0.4, 0, 0.2, 1);
    box-shadow: 0 4px 6px rgba(0,0,0,0.07);
}

.game-card.hover {
    transform: translateY(-10px) scale(1.02);
    box-shadow: 0 20px 40px rgba(0,0,0,0.1);
}

.game-card .card-header {
    background: linear-gradient(135deg, #4361ee 0%, #4361ee 100%);
    padding: 20px;
    position: relative;
    border: none;
}

.game-icon {
    width: 50px;
    height: 50px;   
    background: rgba(255, 255, 255, 0.2);
    border-radius: 50%;
    display: flex;
    align-items: center;
    justify-content: center;
    color: white;
    font-size: 1.2rem;
}

.popular-tag {
    position: absolute;
    top: 10px;
    right: 10px;
    background: linear-gradient(45deg, #f59e0b, #fbbf24);
    color: white;
    padding: 4px 12px;
    border-radius: 20px;
    font-size: 0.8rem;
    font-weight: 600;
}

.game-card .card-body {
    padding: 25px;
}

.game-card .card-title {
    color: #2d3748;
    font-weight: 700;
    font-size: 1.3rem;
    margin-bottom: 15px;
    line-height: 1.4;
}

.game-description {
    color: #ffffffff;
    line-height: 1.6;
    font-size: 0.95rem;
    display: -webkit-box;
    -webkit-line-clamp: 3;
    -webkit-box-orient: vertical;
    overflow: hidden;
}

.game-tags {
    margin-top: 20px;
}

.game-tag {
    display: inline-block;
    padding: 6px 12px;
    border-radius: 6px;
    font-size: 0.85rem;
    font-weight: 500;
}

.game-tag.category {
    background: linear-gradient(135deg, #a3bffa 0%, #e9d8fd 100%);
    color: #4361ee;
}

.game-card .card-footer {
    background: #f8fafc;
    border-top: 1px solid #e2e8f0;
    padding: 20px;
}

.game-card .btn-primary btn-lg {
    background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
    border: none;
    padding: 8px 16px;
    font-weight: 500;
    transition: transform 0.3s ease;
}

.game-card .btn-primary btn-lg:hover {
    transform: translateY(-2px);
}

.game-card .btn-outline-secondary {
    border-color: #cbd5e0;
    color: #718096;
}

.game-card .btn-outline-secondary:hover {
    background-color: #edf2f7;
    border-color: #a0aec0;
}

/* Секция призыва к действию */
.cta-section {
    margin-top: 50px;
}

.cta-card {
    border: none;
    border-radius: 15px;
    background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
    color: white;
    overflow: hidden;
    box-shadow: 0 10px 30px rgba(102, 126, 234, 0.3);
}

.cta-card .card-body {
    padding: 40px;
}

.cta-card h3 {
    font-weight: 700;
    font-size: 2rem;
}

.cta-card p {
    font-size: 1.1rem;
    opacity: 0.9;
}

.cta-card .btn {
    background: white;
    color: #4361ee;
    border: none;
    padding: 12px 40px;
    font-weight: 600;
    font-size: 1.1rem;
    border-radius: 30px;
    transition: all 0.3s ease;
}

.cta-card .btn:hover {
    transform: translateY(-3px);
    box-shadow: 0 10px 20px rgba(255,255,255,0.2);
}

/* Модальное окно */
.game-modal-info .info-label {
    color: #718096;
    font-size: 0.9rem;
    margin-bottom: 5px;
}

.game-modal-info .info-value {
    color: #2d3748;
    font-weight: 500;
}

/* Адаптивность */
@media (max-width: 768px) {
    .catalog-header h1 {
        font-size: 2rem;
    }
    
    .category-title {
        font-size: 1.5rem;
    }
    
    .category-icon {
        width: 50px;
        height: 50px;
    }
    
    .games-count {
        padding: 6px 12px;
        font-size: 1rem;
    }
}

@media (max-width: 576px) {
    .category-section {
        padding: 15px;
    }
    
    .game-card .card-body {
        padding: 20px;
    }
    
    .cta-card .card-body {
        padding: 30px 20px;
    }
    
    .cta-card h3 {
        font-size: 1.5rem;
    }
}
CSS;
$this->registerCss($css);
?>
</div>
</div>
</div>