
<style>
.card {
  border-radius: 12px;
  transition: transform .2s ease, box-shadow .2s ease;
}
.card:hover {
  transform: translateY(-4px);
  box-shadow: 0 12px 30px rgba(0,0,0,.15);
}
.btn {
  transition: all .2s ease;
}
.btn:hover {
  transform: translateY(-1px);
}
.table-hover tbody tr {
  transition: background-color .15s ease;
}
.fade-in {
  animation: fadeIn .4s ease-in-out;
}
@keyframes fadeIn {
  from {opacity:0; transform: translateY(6px);}
  to {opacity:1; transform:none;}
}
</style>

<?php

/* @var $this yii\web\View */

use yii\helpers\Html;

$this->title = 'О нас';
$this->params['breadcrumbs'][] = $this->title;
?>

<div class="site-about">
    <!-- Герой секция -->
    <section class="hero-about py-6 py-lg-7 bg-gradient-primary text-white position-relative overflow-hidden">
        <div class="container position-relative z-2">
            <div class="row align-items-center">
                <div class="col-lg-8 text-center text-lg-start">
                    <h1 class="display-3 fw-bold mb-4 animate__animated animate__fadeInDown">
                        <?= Html::encode($this->title) ?>
                    </h1>
                    <p class="lead fs-3 mb-5 animate__animated animate__fadeIn animate__delay-1s">
                        Создаем незабываемые моменты за игровым столом
                    </p>
                    <div class="d-flex flex-wrap gap-3 justify-content-center justify-content-lg-start animate__animated animate__fadeInUp animate__delay-2s">
                        <a href="<?= \yii\helpers\Url::to(['site/register']) ?>" 
                           class="btn btn-light btn-lg px-5 py-3 rounded-pill fw-bold hover-lift">
                            <i class="fas fa-user-plus me-2"></i>Присоединиться
                        </a>
                        <a href="<?= \yii\helpers\Url::to(['site/catalog']) ?>" 
                           class="btn btn-outline-light btn-lg px-5 py-3 rounded-pill fw-bold hover-lift">
                            <i class="fas fa-th-list me-2"></i>Смотреть игры
                        </a>
                    </div>
                </div>
                <div class="col-lg-4 mt-5 mt-lg-0 text-center">
                    <div class="hero-icon-wrapper position-relative">
                        <div class="floating-icon animate__animated animate__pulse animate__infinite">
                            <i class="fas fa-dice text-white fa-6x"></i>
                        </div>
                        <div class="floating-dots">
                            <span class="dot dot-1"></span>
                            <span class="dot dot-2"></span>
                            <span class="dot dot-3"></span>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="hero-wave">
            <svg viewBox="0 0 1200 120" preserveAspectRatio="none">
                <path d="M321.39,56.44c58-10.79,114.16-30.13,172-41.86,82.39-16.72,168.19-17.73,250.45-.39C823.78,31,906.67,72,985.66,92.83c70.05,18.48,146.53,26.09,214.34,3V0H0V27.35A600.21,600.21,0,0,0,321.39,56.44Z"></path>
            </svg>
        </div>
    </section>

    <!-- О проекте -->
    <section class="about-intro py-6 py-lg-7">
        <div class="container">
            <div class="row justify-content-center">
                <div class="col-lg-10">
                    <div class="card border-0 shadow-lg rounded-4 overflow-hidden">
                        <div class="card-body p-5">
                            <div class="text-center mb-5">
                                <span class="badge bg-primary-soft text-primary rounded-pill px-4 py-2 mb-3">Наша история</span>
                                <h2 class="display-5 fw-bold mb-4">Настолка — сообщество единомышленников</h2>
                                <p class="fs-5 text-muted">
                                    Мы создаем пространство, где люди могут отдохнуть от цифрового мира, 
                                    общаться вживую и развивать стратегическое мышление через настольные игры.
                                </p>
                            </div>

                            <div class="row g-4">
                                <div class="col-md-6">
                                    <div class="mission-card p-4 rounded-3 bg-light h-100">
                                        <div class="mission-icon mb-4">
                                            <i class="fas fa-bullseye fa-3x text-primary"></i>
                                        </div>
                                        <h3 class="h4 fw-bold mb-3">Наша миссия</h3>
                                        <p class="mb-0">
                                            Объединять людей через настольные игры, создавая условия 
                                            для живого общения, интеллектуального развития и качественного отдыха.
                                        </p>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="vision-card p-4 rounded-3 bg-primary text-white h-100">
                                        <div class="vision-icon mb-4">
                                            <i class="fas fa-eye fa-3x text-white"></i>
                                        </div>
                                        <h3 class="h4 fw-bold mb-3">Наше видение</h3>
                                        <p class="mb-0">
                                            Стать крупнейшим сообществом любителей настольных игр в регионе, 
                                            где каждый найдет игру по душе и компанию для игры.
                                        </p>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Преимущества -->
    <section class="features-section py-6 py-lg-7 bg-light-subtle">
        <div class="container">
            <div class="section-header text-center mb-6">
                <span class="badge bg-success-soft text-success rounded-pill px-4 py-2 mb-3">Почему мы</span>
                <h2 class="display-5 fw-bold mb-3">Наши преимущества</h2>
                <p class="text-muted fs-5">Все, что нужно для идеальной игровой сессии</p>
            </div>

            <div class="row g-4">
                <div class="col-lg-3 col-md-6">
                    <div class="feature-card card border-0 shadow-sm h-100 hover-lift">
                        <div class="card-body p-4 text-center">
                            <div class="feature-icon-wrapper mb-4 mx-auto">
                                <div class="icon-circle bg-primary-soft">
                                    <i class="fas fa-users fa-2x text-primary"></i>
                                </div>
                            </div>
                            <h4 class="fw-bold mb-3">Для любой компании</h4>
                            <p class="text-muted">
                                Игры для компаний от 2 до 20 человек любого уровня подготовки.
                            </p>
                        </div>
                    </div>
                </div>

                <div class="col-lg-3 col-md-6">
                    <div class="feature-card card border-0 shadow-sm h-100 hover-lift">
                        <div class="card-body p-4 text-center">
                            <div class="feature-icon-wrapper mb-4 mx-auto">
                                <div class="icon-circle bg-success-soft">
                                    <i class="fas fa-gamepad fa-2x text-success"></i>
                                </div>
                            </div>
                            <h4 class="fw-bold mb-3">Большой выбор игр</h4>
                            <p class="text-muted">
                                Более 50 различных настольных игр: от классики до современных стратегий.
                            </p>
                        </div>
                    </div>
                </div>

                <div class="col-lg-3 col-md-6">
                    <div class="feature-card card border-0 shadow-sm h-100 hover-lift">
                        <div class="card-body p-4 text-center">
                            <div class="feature-icon-wrapper mb-4 mx-auto">
                                <div class="icon-circle bg-warning-soft">
                                    <i class="fas fa-calendar-alt fa-2x text-warning"></i>
                                </div>
                            </div>
                            <h4 class="fw-bold mb-3">Удобное расписание</h4>
                            <p class="text-muted">
                                Регулярные игры по удобному расписанию в различных локациях города.
                            </p>
                        </div>
                    </div>
                </div>

                <div class="col-lg-3 col-md-6">
                    <div class="feature-card card border-0 shadow-sm h-100 hover-lift">
                        <div class="card-body p-4 text-center">
                            <div class="feature-icon-wrapper mb-4 mx-auto">
                                <div class="icon-circle bg-info-soft">
                                    <i class="fas fa-user-friends fa-2x text-info"></i>
                                </div>
                            </div>
                            <h4 class="fw-bold mb-3">Опытные ведущие</h4>
                            <p class="text-muted">
                                Все игры проводятся опытными ведущими, которые помогут освоить правила.
                            </p>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Как это работает -->
    <section class="how-it-works py-6 py-lg-7">
        <div class="container">
            <div class="section-header text-center mb-6">
                <span class="badge bg-danger-soft text-danger rounded-pill px-4 py-2 mb-3">Просто и удобно</span>
                <h2 class="display-5 fw-bold mb-3">Как это работает</h2>
                <p class="text-muted fs-5">Всего 5 простых шагов до увлекательной игры</p>
            </div>

            <div class="steps-wrapper">
                <div class="row g-4 justify-content-center">
                    <?php
                    $steps = [
                        ['Регистрация на сайте', 'user-plus', 'primary'],
                        ['Выбор игры и времени', 'calendar-check', 'success'],
                        ['Запись через сайт', 'clipboard-list', 'warning'],
                        ['Приход в назначенное время', 'map-marker-alt', 'info'],
                        ['Наслаждение игрой', 'smile-beam', 'danger']
                    ];
                    ?>
                    
                    <?php foreach ($steps as $index => $step): ?>
                        <div class="col-lg-2 col-md-4 col-sm-6">
                            <div class="step-card text-center position-relative">
                                <div class="step-number position-absolute top-0 start-50 translate-middle">
                                    <span class="badge bg-<?= $step[2] ?> rounded-circle"><?= $index + 1 ?></span>
                                </div>
                                <div class="card border-0 shadow-sm h-100 pt-5">
                                    <div class="card-body p-4">
                                        <div class="step-icon mb-3">
                                            <div class="icon-circle bg-<?= $step[2] ?>-soft mx-auto">
                                                <i class="fas fa-<?= $step[1] ?> fa-2x text-<?= $step[2] ?>"></i>
                                            </div>
                                        </div>
                                        <h5 class="fw-bold mb-2"><?= $step[0] ?></h5>
                                    </div>
                                </div>
                            </div>
                        </div>
                    <?php endforeach; ?>
                </div>
                <div class="steps-line position-absolute top-50 start-0 w-100 d-none d-lg-block"></div>
            </div>
        </div>
    </section>

    <!-- Наши ценности -->
    <section class="values-section py-6 py-lg-7 bg-light-subtle">
        <div class="container">
            <div class="section-header text-center mb-6">
                <span class="badge bg-info-soft text-info rounded-pill px-4 py-2 mb-3">Наша философия</span>
                <h2 class="display-5 fw-bold mb-3">Наши ценности</h2>
                <p class="text-muted fs-5">Принципы, на которых строится наше сообщество</p>
            </div>

            <div class="row g-4">
                <?php
                $values = [
                    ['Дружелюбная атмосфера', 'hands-helping', 'primary', 'Мы создаем комфортную среду, где каждый чувствует себя желанным гостем.'],
                    ['Инклюзивность', 'users', 'success', 'Игры доступны для всех, независимо от опыта и навыков.'],
                    ['Качество и надежность', 'award', 'warning', 'Только проверенные игры и качественное оборудование.'],
                    ['Профессионализм', 'user-tie', 'info', 'Ведущие — опытные гейм-мастера с отличным знанием правил.'],
                    ['Безопасность и комфорт', 'shield-alt', 'danger', 'Соблюдение правил и создание безопасной среды.'],
                    ['Развитие сообщества', 'heart', 'purple', 'Мы растем вместе с нашими участниками и помогаем им развиваться.']
                ];
                ?>

                <?php foreach ($values as $value): ?>
                    <div class="col-lg-4 col-md-6">
                        <div class="value-card card border-0 shadow-sm h-100 hover-lift">
                            <div class="card-body p-4">
                                <div class="d-flex align-items-start">
                                    <div class="value-icon me-3">
                                        <div class="icon-circle bg-<?= $value[2] ?>-soft">
                                            <i class="fas fa-<?= $value[1] ?> fa-lg text-<?= $value[2] ?>"></i>
                                        </div>
                                    </div>
                                    <div class="flex-grow-1">
                                        <h4 class="fw-bold mb-2"><?= $value[0] ?></h4>
                                        <p class="text-muted mb-0"><?= $value[3] ?></p>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                <?php endforeach; ?>
            </div>
        </div>
    </section>

    <!-- Призыв к действию -->
    <section class="cta-section py-6 py-lg-7 bg-gradient-primary text-white">
        <div class="container">
            <div class="row justify-content-center">
                <div class="col-lg-8 text-center">
                    <h2 class="display-5 fw-bold mb-4">Присоединяйтесь к нашему сообществу</h2>
                    <p class="fs-5 mb-5 opacity-90">
                        Начните свое путешествие в мир настольных игр уже сегодня. 
                        Найдите новых друзей, откройте для себя увлекательные игры и создавайте незабываемые воспоминания.
                    </p>
                    <div class="d-flex flex-wrap gap-3 justify-content-center">
                        <a href="<?= \yii\helpers\Url::to(['site/register']) ?>" 
                           class="btn btn-light btn-lg px-5 py-3 rounded-pill fw-bold hover-lift">
                            <i class="fas fa-user-plus me-2"></i>Зарегистрироваться
                        </a>
                        <a href="<?= \yii\helpers\Url::to(['site/catalog']) ?>" 
                           class="btn btn-outline-light btn-lg px-5 py-3 rounded-pill fw-bold hover-lift">
                            <i class="fas fa-gamepad me-2"></i>Посмотреть игры
                        </a>
                    </div>
                </div>
            </div>
        </div>
    </section>
</div>

<style>
:root {
    --primary: #4361ee;
    --primary-soft: #eef2ff;
    --success: #10b981;
    --success-soft: #d1fae5;
    --warning: #f59e0b;
    --warning-soft: #fef3c7;
    --danger: #ef4444;
    --danger-soft: #fee2e2;
    --info: #0ea5e9;
    --info-soft: #e0f2fe;
    --purple: #8b5cf6;
    --purple-soft: #ede9fe;
}

/* Герой секция */
.hero-about {
    position: relative;
    overflow: hidden;
}

.hero-wave {
    position: absolute;
    bottom: 0;
    left: 0;
    width: 100%;
    overflow: hidden;
    line-height: 0;
}

.hero-wave svg {
    position: relative;
    display: block;
    width: calc(100% + 1.3px);
    height: 120px;
    transform: rotate(180deg);
}

.hero-wave svg path {
    fill: #ffffff;
}

.floating-icon {
    animation: float 6s ease-in-out infinite;
}

.floating-dots {
    position: absolute;
    top: 50%;
    left: 50%;
    transform: translate(-50%, -50%);
    width: 300px;
    height: 300px;
}

.floating-dots .dot {
    position: absolute;
    width: 8px;
    height: 8px;
    background: rgba(255, 255, 255, 0.5);
    border-radius: 50%;
}

.dot-1 {
    top: 20%;
    left: 10%;
    animation: pulse 2s infinite;
}

.dot-2 {
    top: 60%;
    right: 15%;
    animation: pulse 2s infinite 0.5s;
}

.dot-3 {
    bottom: 30%;
    left: 20%;
    animation: pulse 2s infinite 1s;
}

@keyframes float {
    0%, 100% { transform: translateY(0); }
    50% { transform: translateY(-20px); }
}

@keyframes pulse {
    0%, 100% { opacity: 0.5; transform: scale(1); }
    50% { opacity: 1; transform: scale(1.2); }
}

/* Общие стили */
.bg-gradient-primary {
    background: linear-gradient(135deg, var(--primary) 0%, #3a56d4 100%);
}

.bg-primary-soft { background-color: var(--primary-soft) !important; }
.bg-success-soft { background-color: var(--success-soft) !important; }
.bg-warning-soft { background-color: var(--warning-soft) !important; }
.bg-danger-soft { background-color: var(--danger-soft) !important; }
.bg-info-soft { background-color: var(--info-soft) !important; }

.text-primary-soft { color: var(--primary-soft) !important; }

.hover-lift {
    transition: transform 0.3s ease, box-shadow 0.3s ease;
}

.hover-lift:hover {
    transform: translateY(-5px);
    box-shadow: 0 10px 25px rgba(0, 0, 0, 0.15) !important;
}

.icon-circle {
    width: 80px;
    height: 80px;
    border-radius: 50%;
    display: flex;
    align-items: center;
    justify-content: center;
}

/* Карточки */
.mission-card, .vision-card {
    transition: transform 0.3s ease;
}

.mission-card:hover {
    transform: translateY(-5px);
}

.vision-card {
    background: linear-gradient(135deg, var(--primary) 0%, #3a56d4 100%);
}

.feature-card {
    border-radius: 16px;
    transition: all 0.3s ease;
}

.feature-card .feature-icon-wrapper .icon-circle {
    width: 100px;
    height: 100px;
    transition: transform 0.3s ease;
}

.feature-card:hover .feature-icon-wrapper .icon-circle {
    transform: scale(1.1);
}

/* Шаги */
.steps-wrapper {
    position: relative;
    padding: 40px 0;
}

.steps-line {
    height: 4px;
    background: linear-gradient(90deg, var(--primary), var(--success), var(--warning), var(--info), var(--danger));
    z-index: 1;
}

.step-card .step-number {
    z-index: 2;
}

.step-card .step-number .badge {
    width: 40px;
    height: 40px;
    display: flex;
    align-items: center;
    justify-content: center;
    font-size: 1.2rem;
    font-weight: bold;
}

.step-card .card {
    border-radius: 16px;
    background: #fff;
    z-index: 2;
}

/* Ценности */
.value-card {
    border-radius: 12px;
    border-left: 4px solid var(--primary);
}

.value-card .value-icon .icon-circle {
    width: 60px;
    height: 60px;
    flex-shrink: 0;
}

/* Адаптивность */
@media (max-width: 768px) {
    .display-3 {
        font-size: 2.5rem;
    }
    
    .display-5 {
        font-size: 2rem;
    }
    
    .hero-about {
        padding-top: 4rem !important;
        padding-bottom: 4rem !important;
    }
    
    .steps-wrapper {
        padding: 20px 0;
    }
    
    .step-card .card {
        margin-bottom: 2rem;
    }
}

@media (max-width: 576px) {
    .btn-lg {
        padding: 0.75rem 1.5rem;
        font-size: 1rem;
        width: 100%;
        margin-bottom: 0.5rem;
    }
    
    .d-flex.flex-wrap {
        flex-direction: column;
    }
}
</style>

<?php
$js = <<<JS
$(document).ready(function() {
    // Анимация появления элементов при скролле
    function animateOnScroll() {
        $('.feature-card, .step-card, .value-card').each(function() {
            var element = $(this);
            var position = element.offset().top;
            var scroll = $(window).scrollTop();
            var windowHeight = $(window).height();
            
            if (position < scroll + windowHeight - 100) {
                element.addClass('animate__animated animate__fadeInUp');
            }
        });
    }
    
    // Запускаем анимацию при загрузке и скролле
    animateOnScroll();
    $(window).on('scroll', animateOnScroll);
    
    // Плавная прокрутка для якорей
    $('a[href^="#"]').on('click', function(e) {
        var target = $(this.getAttribute('href'));
        if (target.length) {
            e.preventDefault();
            $('html, body').stop().animate({
                scrollTop: target.offset().top - 80
            }, 1000);
        }
    });
});
JS;
$this->registerJs($js);
?>