
<style>
.card {
  border-radius: 12px;
  transition: transform .2s ease, box-shadow .2s ease;
}
.card:hover {
  transform: translateY(-4px);
  box-shadow: 0 12px 30px rgba(0,0,0,.15);
}
.btn {
  transition: all .2s ease;
}
.btn:hover {
  transform: translateY(-1px);
}
.table-hover tbody tr {
  transition: background-color .15s ease;
}
.fade-in {
  animation: fadeIn .4s ease-in-out;
}
@keyframes fadeIn {
  from {opacity:0; transform: translateY(6px);}
  to {opacity:1; transform:none;}
}
</style>

<div class="container my-4">
<div class="card shadow-sm fade-in">
<div class="card-body">
<?php

/* @var $model app\models\Application */

use yii\helpers\Html;
use yii\helpers\Url;

?>
    <div class="modal fade" id="applicationModal" tabindex="-1">
        <div class="modal-dialog modal-lg">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">Заявка #<?= $model->id ?></h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                </div>
                <div class="modal-body">
                    <div class="row">
                        <div class="col-md-6">
                            <div class="card mb-3">
                                <div class="card-header bg-primary text-white">
                                    <h6 class="mb-0">Детали игры</h6>
                                </div>
                                <div class="card-body">
                                    <div class="d-flex align-items-center mb-3">
                                        <i class="fas fa-dice fa-2x text-primary me-3"></i>
                                        <div>
                                            <h5 class="mb-0"><?= Html::encode($model->game_name) ?></h5>
                                            <small class="text-muted"><?= $model->game_category ?></small>
                                        </div>
                                    </div>

                                    <ul class="list-unstyled">
                                        <li class="mb-2">
                                            <i class="far fa-calendar me-2 text-primary"></i>
                                            <strong>Дата:</strong> <?= Yii::$app->formatter->asDate($model->date) ?>
                                        </li>
                                        <li class="mb-2">
                                            <i class="far fa-clock me-2 text-primary"></i>
                                            <strong>Время:</strong> <?= $model->start_time ?>
                                        </li>
                                        <li class="mb-2">
                                            <i class="fas fa-map-marker-alt me-2 text-primary"></i>
                                            <strong>Адрес:</strong> <?= Html::encode($model->address) ?>
                                        </li>
                                        <li>
                                            <i class="fas fa-tag me-2 text-primary"></i>
                                            <strong>Стоимость:</strong> <?= $model->price ?> ₽
                                        </li>
                                    </ul>
                                </div>
                            </div>
                        </div>

                        <div class="col-md-6">
                            <div class="card mb-3">
                                <div class="card-header bg-success text-white">
                                    <h6 class="mb-0">Ваши данные</h6>
                                </div>
                                <div class="card-body">
                                    <ul class="list-unstyled">
                                        <li class="mb-2">
                                            <i class="fas fa-user me-2 text-success"></i>
                                            <strong>ФИО:</strong> <?= Html::encode($model->full_name) ?>
                                        </li>
                                        <li class="mb-2">
                                            <i class="fas fa-phone me-2 text-success"></i>
                                            <strong>Телефон:</strong> <?= Html::encode($model->phone) ?>
                                        </li>
                                        <li class="mb-2">
                                            <i class="fas fa-envelope me-2 text-success"></i>
                                            <strong>Email:</strong> <?= Html::encode($model->email) ?>
                                        </li>
                                        <li class="mb-2">
                                            <i class="fas fa-user-graduate me-2 text-success"></i>
                                            <strong>Уровень:</strong> <?= $model->getPlayerLevelLabel() ?>
                                        </li>
                                        <li>
                                            <i class="fas fa-credit-card me-2 text-success"></i>
                                            <strong>Оплата:</strong> <?= $model->getPaymentMethodLabel() ?>
                                        </li>
                                    </ul>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-12">
                            <div class="card">
                                <div class="card-header bg-info text-white">
                                    <h6 class="mb-0">Статус заявки</h6>
                                </div>
                                <div class="card-body">
                                    <div class="text-center">
                                        <div class="mb-3">
                                        <span class="badge bg-<?= $model->status === 'new' ? 'warning' :
                                            ($model->status === 'approved' ? 'success' : 'info') ?> p-3 fs-5">
                                            <i class="fas fa-<?= $model->status === 'new' ? 'clock' :
                                                ($model->status === 'approved' ? 'check-circle' : 'flag-checkered') ?> me-2"></i>
                                            <?= $model->getStatusLabel() ?>
                                        </span>
                                        </div>

                                        <?php if ($model->status === 'new'): ?>
                                            <div class="alert alert-warning">
                                                <i class="fas fa-info-circle me-2"></i>
                                                Ваша заявка находится на рассмотрении. Администратор свяжется с вами в течение 24 часов.
                                            </div>
                                        <?php elseif ($model->status === 'approved'): ?>
                                            <div class="alert alert-success">
                                                <i class="fas fa-check-circle me-2"></i>
                                                Ваша заявка одобрена! Ждем вас на игре.
                                            </div>
                                        <?php else: ?>
                                            <div class="alert alert-info">
                                                <i class="fas fa-flag-checkered me-2"></i>
                                                Игра завершена. Надеемся, вам понравилось!
                                            </div>
                                        <?php endif; ?>

                                        <div class="text-muted small">
                                            <i class="far fa-clock me-1"></i>
                                            Создана: <?= Yii::$app->formatter->asDatetime($model->created_at) ?>
                                            <?php if ($model->updated_at != $model->created_at): ?>
                                                <br><i class="fas fa-sync-alt me-1"></i>
                                                Обновлена: <?= Yii::$app->formatter->asDatetime($model->updated_at) ?>
                                            <?php endif; ?>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Закрыть</button>
                    <?php if ($model->status === 'completed'): ?>
                        <button type="button" class="btn btn-primary btn-lg" id="add-review-btn">
                            <i class="fas fa-star me-1"></i> Оставить отзыв
                        </button>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>

<?php if ($model->status === 'completed'): ?>
    <?php
    $js = <<<JS
$(document).ready(function() {
    $('#add-review-btn').on('click', function() {
        $('#applicationModal').modal('hide');
        
        // Показываем форму отзыва
        var reviewForm = `
            <div class="modal fade" id="reviewFormModal" tabindex="-1">
                <div class="modal-dialog">
                    <div class="modal-content">
                        <div class="modal-header">
                            <h5 class="modal-title">Оставить отзыв</h5>
                            <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                        </div>
                        <div class="modal-body">
                            <form id="review-form">
                                <div class="mb-3 text-center">
                                    <label class="form-label">Рейтинг:</label>
                                    <div class="rating-stars mb-2">
                                        <i class="fas fa-star fa-2x star" data-rating="1"></i>
                                        <i class="fas fa-star fa-2x star" data-rating="2"></i>
                                        <i class="fas fa-star fa-2x star" data-rating="3"></i>
                                        <i class="fas fa-star fa-2x star" data-rating="4"></i>
                                        <i class="fas fa-star fa-2x star" data-rating="5"></i>
                                    </div>
                                    <input type="hidden" name="rating" id="rating-value" value="5">
                                </div>
                                
                                <div class="mb-3">
                                    <label for="comment" class="form-label">Ваш отзыв:</label>
                                    <textarea class="form-control" id="comment" name="comment" rows="4" 
                                              placeholder="Поделитесь впечатлениями об игре..." required></textarea>
                                </div>
                                
                                <input type="hidden" name="application_id" value="$model->id">
                            </form>
                        </div>
                        <div class="modal-footer">
                            <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Отмена</button>
                            <button type="button" class="btn btn-primary btn-lg" id="submit-review">Отправить отзыв</button>
                        </div>
                    </div>
                </div>
            </div>
        `;
        
        $('body').append(reviewForm);
        var modal = new bootstrap.Modal(document.getElementById('reviewFormModal'));
        modal.show();
        
        // Обработка звезд рейтинга
        $('.star').on('mouseenter', function() {
            var rating = $(this).data('rating');
            $('.star').each(function(i) {
                if (i < rating) {
                    $(this).removeClass('far').addClass('fas text-warning');
                } else {
                    $(this).removeClass('fas text-warning').addClass('far');
                }
            });
        });
        
        $('.star').on('click', function() {
            var rating = $(this).data('rating');
            $('#rating-value').val(rating);
        });
        
        // Отправка отзыва
        $('#submit-review').on('click', function() {
            var formData = $('#review-form').serialize();
            
            $.ajax({
                url: '/site/add-review',
                type: 'POST',
                data: formData,
                success: function(response) {
                    if (response.success) {
                        $('#reviewFormModal').modal('hide');
                        alert('Спасибо за ваш отзыв!');
                    } else {
                        alert('Ошибка: ' + response.errors);
                    }
                }
            });
        });
        
        $('#reviewFormModal').on('hidden.bs.modal', function() {
            $(this).remove();
        });
    });
});
JS;
    $this->registerJs($js);

    $css = <<<CSS
.rating-stars {
    cursor: pointer;
}
.rating-stars .star {
    color: #ddd;
    transition: color 0.3s;
}
.rating-stars .star:hover,
.rating-stars .star.active {
    color: #ffc107;
}
CSS;
    $this->registerCss($css);
    ?>
<?php endif; ?>
</div>
</div>
</div>