
<style>
.card {
  border-radius: 12px;
  transition: transform .2s ease, box-shadow .2s ease;
}
.card:hover {
  transform: translateY(-4px);
  box-shadow: 0 12px 30px rgba(0,0,0,.15);
}
.btn {
  transition: all .2s ease;
}
.btn:hover {
  transform: translateY(-1px);
}
.table-hover tbody tr {
  transition: background-color .15s ease;
}
.fade-in {
  animation: fadeIn .4s ease-in-out;
}
@keyframes fadeIn {
  from {opacity:0; transform: translateY(6px);}
  to {opacity:1; transform:none;}
}
</style>

<div class="container my-4">
<div class="card shadow-sm fade-in">
<div class="card-body">
<?php

/* @var $model app\models\Application */

use yii\helpers\Html;
use yii\helpers\Url;

?>
    <div class="card h-100">
        <div class="card-header d-flex justify-content-between align-items-center">
        <span class="badge bg-<?= $model->status === 'new' ? 'warning' :
            ($model->status === 'approved' ? 'success' : 'info') ?>">
            <?= $model->getStatusLabel() ?>
        </span>
            <small class="text-muted">#<?= $model->id ?></small>
        </div>
        <div class="card-body">
            <h5 class="card-title"><?= Html::encode($model->game_name) ?></h5>
            <h6 class="card-subtitle mb-3 text-muted"><?= $model->game_category ?></h6>

            <ul class="list-unstyled mb-4">
                <li class="mb-2">
                    <i class="far fa-calendar me-2 text-primary"></i>
                    <strong>Дата:</strong> <?= Yii::$app->formatter->asDate($model->date) ?>
                </li>
                <li class="mb-2">
                    <i class="far fa-clock me-2 text-primary"></i>
                    <strong>Время:</strong> <?= $model->start_time ?>
                </li>
                <li class="mb-2">
                    <i class="fas fa-map-marker-alt me-2 text-primary"></i>
                    <strong>Адрес:</strong> <?= Html::encode($model->address) ?>
                </li>
                <li class="mb-2">
                    <i class="fas fa-tag me-2 text-primary"></i>
                    <strong>Стоимость:</strong> <?= $model->price ?> ₽
                </li>
                <li>
                    <i class="fas fa-user me-2 text-primary"></i>
                    <strong>Уровень:</strong> <?= $model->getPlayerLevelLabel() ?>
                </li>
            </ul>

            <div class="text-muted small">
                <i class="far fa-clock me-1"></i>
                Создана: <?= Yii::$app->formatter->asRelativeTime($model->created_at) ?>
            </div>
        </div>
        <div class="card-footer bg-transparent">
            <div class="d-grid">
                <button type="button" class="btn btn-outline-primary view-details" data-id="<?= $model->id ?>">
                    <i class="fas fa-eye me-2"></i>Подробнее
                </button>
            </div>
        </div>
    </div>

<?php
// Модальное окно для детального просмотра
$js = <<<JS
$(document).ready(function() {
    $('.view-details').on('click', function() {
        var id = $(this).data('id');
        
        $.ajax({
            url: '/site/view-application?id=' + id,
            type: 'GET',
            success: function(data) {
                $('body').append(data);
                var modal = new bootstrap.Modal(document.getElementById('applicationModal'));
                modal.show();
                
                $('#applicationModal').on('hidden.bs.modal', function() {
                    $(this).remove();
                });
            }
        });
    });
});
JS;
$this->registerJs($js);
?>
</div>
</div>
</div>