
<style>
.card {
  border-radius: 12px;
  transition: transform .2s ease, box-shadow .2s ease;
}
.card:hover {
  transform: translateY(-4px);
  box-shadow: 0 12px 30px rgba(0,0,0,.15);
}
.btn {
  transition: all .2s ease;
}
.btn:hover {
  transform: translateY(-1px);
}
.table-hover tbody tr {
  transition: background-color .15s ease;
}
.fade-in {
  animation: fadeIn .4s ease-in-out;
}
@keyframes fadeIn {
  from {opacity:0; transform: translateY(6px);}
  to {opacity:1; transform:none;}
}
</style>

<?php

/* @var $this \yii\web\View */
/* @var $content string */

use yii\helpers\Html;
use yii\helpers\Url;
use yii\bootstrap5\Nav;
use yii\bootstrap5\NavBar;
use yii\widgets\Breadcrumbs;
use app\assets\AppAsset;

AppAsset::register($this);
?>
<?php $this->beginPage() ?>
    <!DOCTYPE html>
    <html lang="<?= Yii::$app->language ?>">
    <head>
        <meta charset="<?= Yii::$app->charset ?>">
        <meta name="viewport" content="width=device-width, initial-scale=1">
        <?= Html::csrfMetaTags() ?>
        <title><?= Html::encode($this->title) ?> | Настолка</title>

        <!-- Bootstrap 5 -->
        <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/css/bootstrap.min.css" rel="stylesheet">

        <!-- Font Awesome -->
        <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">

        <!-- Google Fonts -->
        <link href="https://fonts.googleapis.com/css2?family=Roboto:wght@300;400;500;700&display=swap" rel="stylesheet">

        <?php $this->head() ?>

        <style>
            :root {
                --primary-color: #667eea;
                --secondary-color: #764ba2;
                --accent-color: #ff6b6b;
            }

            body {
                font-family: 'Roboto', sans-serif;
                padding-top: 0;
                display: flex;
                flex-direction: column;
                min-height: 100vh;
            }

            .wrapper {
                flex: 1;
            }

            .navbar-brand {
                font-weight: 700;
                font-size: 1.5rem;
                color: var(--primary-color) !important;
            }

            .navbar-brand img {
                margin-right: 10px;
            }

            .nav-link {
                font-weight: 500;
                padding: 0.5rem 1rem !important;
            }

            .dropdown-item {
                padding: 0.5rem 1rem;
            }

            .footer {
                background: #343a40;
                color: #fff;
                padding: 3rem 0;
                margin-top: auto;
            }

            .footer h5 {
                color: #fff;
                margin-bottom: 1.5rem;
                font-weight: 600;
            }

            .footer-links {
                list-style: none;
                padding: 0;
            }

            .footer-links li {
                margin-bottom: 0.5rem;
            }

            .footer-links a {
                color: #adb5bd;
                text-decoration: none;
                transition: color 0.3s;
            }

            .footer-links a:hover {
                color: #fff;
            }

            .social-icons {
                display: flex;
                gap: 1rem;
            }

            .social-icons a {
                color: #fff;
                font-size: 1.2rem;
                transition: color 0.3s;
            }

            .social-icons a:hover {
                color: var(--primary-color);
            }

            .copyright {
                border-top: 1px solid #495057;
                padding-top: 1.5rem;
                margin-top: 2rem;
                text-align: center;
                color: #adb5bd;
            }

            .flash-messages {
                position: fixed;
                top: 80px;
                right: 20px;
                z-index: 1000;
                max-width: 400px;
            }

            .alert {
                box-shadow: 0 4px 6px rgba(0,0,0,0.1);
            }

            @media (max-width: 768px) {
                .flash-messages {
                    left: 20px;
                    right: 20px;
                    max-width: none;
                }
            }
        </style>
    </head>
    <body>
    <?php $this->beginBody() ?>

    <div class="wrapper">
        <!-- Навигационная панель -->
        <nav class="navbar navbar-expand-lg navbar-light bg-white shadow-sm sticky-top">
            <div class="container">
                <a class="navbar-brand d-flex align-items-center" href="<?= Url::home() ?>">
                    <i class="fas fa-dice me-2 text-primary"></i>
                    <span>Настолка</span>
                </a>

                <button class="navbar-toggler" type="button" data-bs-toggle="collapse"
                        data-bs-target="#navbarContent" aria-controls="navbarContent"
                        aria-expanded="false" aria-label="Toggle navigation">
                    <span class="navbar-toggler-icon"></span>
                </button>

                <div class="collapse navbar-collapse" id="navbarContent">
                    <ul class="navbar-nav me-auto mb-2 mb-lg-0">
                        <li class="nav-item">
                            <a class="nav-link" href="<?= Url::to(['site/about']) ?>">
                                <i class="fas fa-info-circle me-1"></i> О нас
                            </a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link" href="<?= Url::to(['site/catalog']) ?>">
                                <i class="fas fa-th-list me-1"></i> Каталог игр
                            </a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link" href="<?= Url::to(['site/create-application']) ?>">
                                <i class="fas fa-calendar-plus me-1"></i> Запись на игру
                            </a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link" href="<?= Url::to(['site/contact']) ?>">
                                <i class="fas fa-envelope me-1"></i> Контакты
                            </a>
                        </li>
                    </ul>

                    <ul class="navbar-nav">
                        <?php if (Yii::$app->user->isGuest): ?>
                            <li class="nav-item">
                                <a class="nav-link" href="<?= Url::to(['site/login']) ?>">
                                    <i class="fas fa-sign-in-alt me-1"></i> Вход
                                </a>
                            </li>
                            <li class="nav-item">
                                <a class="btn btn-primary btn-lg ms-2" href="<?= Url::to(['site/register']) ?>">
                                    <i class="fas fa-user-plus me-1"></i> Регистрация
                                </a>
                            </li>
                        <?php else: ?>
                            <li class="nav-item dropdown">
                                <a class="nav-link dropdown-toggle d-flex align-items-center" href="#"
                                   id="userDropdown" role="button" data-bs-toggle="dropdown">
                                    <i class="fas fa-user-circle me-1"></i>
                                    <?= Html::encode(Yii::$app->user->identity->full_name) ?>
                                </a>
                                <ul class="dropdown-menu dropdown-menu-end">
                                    <li>
                                        <a class="dropdown-item" href="<?= Url::to(['site/profile']) ?>">
                                            <i class="fas fa-user me-2"></i> Профиль
                                        </a>
                                    </li>
                                    <li>
                                        <a class="dropdown-item" href="<?= Url::to(['site/applications']) ?>">
                                            <i class="fas fa-list-alt me-2"></i> Мои заявки
                                        </a>
                                    </li>
                                    <li><hr class="dropdown-divider"></li>

                                    <?php if (Yii::$app->user->identity->phone === '89999999999'): ?>
                                        <li>
                                            <a class="dropdown-item text-danger" href="<?= Url::to(['admin/index']) ?>">
                                                <i class="fas fa-cogs me-2"></i> Панель администратора
                                            </a>
                                        </li>
                                        <li><hr class="dropdown-divider"></li>
                                    <?php endif; ?>

                                    <li>
                                        <a class="dropdown-item" href="<?= Url::to(['site/logout']) ?>"
                                           data-method="post">
                                            <i class="fas fa-sign-out-alt me-2"></i> Выход
                                        </a>
                                    </li>
                                </ul>
                            </li>
                        <?php endif; ?>
                    </ul>
                </div>
            </div>
        </nav>

        <!-- Хлебные крошки -->
        <?php if (!empty($this->params['breadcrumbs'])): ?>
            <div class="container mt-3">
                <?= Breadcrumbs::widget([
                    'links' => isset($this->params['breadcrumbs']) ? $this->params['breadcrumbs'] : [],
                    'options' => ['class' => 'breadcrumb'],
                    'itemTemplate' => "<li class='breadcrumb-item'>{link}</li>\n",
                    'activeItemTemplate' => "<li class='breadcrumb-item active'>{link}</li>\n",
                ]) ?>
            </div>
        <?php endif; ?>

        <!-- Flash сообщения -->
        <div class="flash-messages">
            <?php foreach (Yii::$app->session->getAllFlashes() as $type => $message): ?>
                <?php if (in_array($type, ['success', 'danger', 'warning', 'info'])): ?>
                    <div class="alert alert-<?= $type ?> alert-dismissible fade show" role="alert">
                        <?= $message ?>
                        <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                    </div>
                <?php endif; ?>
            <?php endforeach; ?>
        </div>

        <!-- Основное содержимое -->
        <main class="container py-4">
            <?= $content ?>
        </main>
    </div>

    <!-- Подвал -->
    <footer class="footer">
        <div class="container">
            <div class="row">
                <div class="col-md-4 mb-4">
                    <h5>Настолка</h5>
                    <p>Сообщество любителей настольных игр. Организуем игры для компаний любого размера и уровня подготовки.</p>
                    <div class="social-icons">
                        <a href="#"><i class="fab fa-vk"></i></a>
                        <a href="#"><i class="fab fa-telegram"></i></a>
                        <a href="#"><i class="fab fa-instagram"></i></a>
                        <a href="#"><i class="fab fa-youtube"></i></a>
                    </div>
                </div>

                <div class="col-md-2 mb-4">
                    <h5>Меню</h5>
                    <ul class="footer-links">
                        <li><a href="<?= Url::home() ?>">Главная</a></li>
                        <li><a href="<?= Url::to(['site/about']) ?>">О нас</a></li>
                        <li><a href="<?= Url::to(['site/catalog']) ?>">Каталог игр</a></li>
                        <li><a href="<?= Url::to(['site/create-application']) ?>">Запись на игру</a></li>
                    </ul>
                </div>

                <div class="col-md-3 mb-4">
                    <h5>Для игроков</h5>
                    <ul class="footer-links">
                        <?php if (Yii::$app->user->isGuest): ?>
                            <li><a href="<?= Url::to(['site/login']) ?>">Вход</a></li>
                            <li><a href="<?= Url::to(['site/register']) ?>">Регистрация</a></li>
                        <?php else: ?>
                            <li><a href="<?= Url::to(['site/profile']) ?>">Профиль</a></li>
                            <li><a href="<?= Url::to(['site/applications']) ?>">Мои заявки</a></li>
                        <?php endif; ?>
                        <li><a href="<?= Url::to(['site/contact']) ?>">Контакты</a></li>
                        <li><a href="<?= Url::to(['site/contact']) ?>">Помощь</a></li>
                    </ul>
                </div>

                <div class="col-md-3 mb-4">
                    <h5>Контакты</h5>
                    <ul class="footer-links">
                        <li>
                            <i class="fas fa-map-marker-alt me-2"></i>
                            г. Москва, ул. Примерная, д. 10
                        </li>
                        <li>
                            <i class="fas fa-phone me-2"></i>
                            <a href="tel:+74951234567">+7 (495) 123-45-67</a>
                        </li>
                        <li>
                            <i class="fas fa-envelope me-2"></i>
                            <a href="mailto:info@nastolka.ru">info@nastolka.ru</a>
                        </li>
                        <li>
                            <i class="fas fa-clock me-2"></i>
                            Ежедневно 10:00 - 22:00
                        </li>
                    </ul>
                </div>
            </div>

            <div class="copyright">
                <div class="row">
                    <div class="col-md-6">
                        &copy; <?= date('Y') ?> Настолка. Все права защищены.
                    </div>
                    <div class="col-md-6 text-md-end">
                        <a href="#" class="text-muted me-3">Политика конфиденциальности</a>
                        <a href="#" class="text-muted">Пользовательское соглашение</a>
                    </div>
                </div>
            </div>
        </div>
    </footer>

    <!-- Bootstrap JS -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/js/bootstrap.bundle.min.js"></script>

    <!-- jQuery (если нужен для Yii) -->
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>

    <script>
        // Автоматическое скрытие flash сообщений через 5 секунд
        $(document).ready(function() {
            setTimeout(function() {
                $('.alert').alert('close');
            }, 5000);

            // Обработка выпадающих меню
            $('.dropdown-toggle').dropdown();

            // Плавная прокрутка для якорных ссылок
            $('a[href^="#"]').on('click', function(event) {
                if (this.hash !== '') {
                    event.preventDefault();
                    const hash = this.hash;
                    $('html, body').animate({
                        scrollTop: $(hash).offset().top - 70
                    }, 800);
                }
            });
        });
    </script>

    <?php $this->endBody() ?>
    </body>
    </html>
<?php $this->endPage() ?>