<?php
/* @var $this yii\web\View */
/* @var $dataProvider yii\data\ActiveDataProvider */

use yii\helpers\Html;
use yii\helpers\Url;

$this->title = 'Управление отзывами';
$this->params['breadcrumbs'][] = $this->title;
?>

<div class="admin-reviews">
    <!-- Хедер страницы -->
    <div class="row mb-4">
        <div class="col-12">
            <div class="d-flex align-items-center justify-content-between mb-4">
                <div>
                    <h1 class="h2 mb-2"><?= Html::encode($this->title) ?></h1>
                    <p class="text-muted">Управление отзывами пользователей</p>
                </div>
                <div class="text-end">
                    <span class="badge bg-primary-light text-primary">
                        <i class="fas fa-star me-1"></i>
                        Всего: <?= $dataProvider->getTotalCount() ?>
                    </span>
                </div>
            </div>
        </div>
    </div>

    <!-- Таблица отзывов -->
    <div class="card border-0 shadow-sm">
        <div class="card-header border-0 bg-transparent d-flex justify-content-between align-items-center py-4">
            <h5 class="mb-0 fw-medium">Список отзывов</h5>
            <div class="dropdown">
                <button class="btn btn-sm btn-outline-secondary rounded-pill dropdown-toggle" type="button" data-bs-toggle="dropdown">
                    <i class="fas fa-filter me-1"></i> Фильтры
                </button>
                <ul class="dropdown-menu dropdown-menu-end">
                    <li><a class="dropdown-item" href="#"><i class="fas fa-sort-numeric-up me-2"></i>По дате (новые)</a></li>
                    <li><a class="dropdown-item" href="#"><i class="fas fa-sort-numeric-down me-2"></i>По дате (старые)</a></li>
                    <li><a class="dropdown-item" href="#"><i class="fas fa-star me-2"></i>По рейтингу</a></li>
                </ul>
            </div>
        </div>
        <div class="card-body pt-0">
            <div class="table-responsive">
                <table class="table table-hover table-borderless align-middle">
                    <thead class="table-light">
                    <tr>
                        <th class="small text-uppercase text-muted" width="80">ID</th>
                        <th class="small text-uppercase text-muted">Пользователь</th>
                        <th class="small text-uppercase text-muted" width="120">Рейтинг</th>
                        <th class="small text-uppercase text-muted">Отзыв</th>
                        <th class="small text-uppercase text-muted" width="140">Дата</th>
                        <th class="small text-uppercase text-muted text-end" width="100">Действия</th>
                    </tr>
                    </thead>
                    <tbody>
                    <?php foreach ($dataProvider->getModels() as $review): ?>
                        <tr class="border-bottom">
                            <td>
                                <span class="badge bg-light text-dark">#<?= $review->id ?></span>
                            </td>
                            <td>
                                <div class="d-flex align-items-center">
                                    <div class="avatar-circle-sm bg-light text-muted me-3">
                                        <i class="fas fa-user fa-sm"></i>
                                    </div>
                                    <div>
                                        <div class="fw-medium">
                                            <?php if ($review->user): ?>
                                                <?= Html::encode($review->user->full_name) ?>
                                            <?php else: ?>
                                                <span class="text-muted">Пользователь удален</span>
                                            <?php endif; ?>
                                        </div>
                                        <?php if ($review->user): ?>
                                            <small class="text-muted"><?= $review->user->email ?></small>
                                        <?php endif; ?>
                                    </div>
                                </div>
                            </td>
                            <td>
                                <div class="d-flex align-items-center">
                                    <div class="text-warning me-2">
                                        <?= str_repeat('★', $review->rating) ?>
                                    </div>
                                    <span class="badge bg-warning-light text-warning rounded-pill">
                                        <?= $review->rating ?>.0
                                    </span>
                                </div>
                            </td>
                            <td>
                                <div class="review-preview">
                                    <p class="mb-0 text-truncate" style="max-width: 300px;">
                                        <?= Html::encode(mb_substr($review->comment, 0, 100)) ?>
                                        <?php if (mb_strlen($review->comment) > 100): ?>...<?php endif; ?>
                                    </p>
                                </div>
                            </td>
                            <td>
                                <div class="small">
                                    <div class="fw-medium"><?= Yii::$app->formatter->asDate($review->created_at) ?></div>
                                    <small class="text-muted"><?= Yii::$app->formatter->asRelativeTime($review->created_at) ?></small>
                                </div>
                            </td>
                            <td class="text-end">
                                <div class="btn-group" role="group">
                                    <button type="button" class="btn btn-sm btn-outline-info rounded-circle view-review"
                                            data-id="<?= $review->id ?>" title="Просмотреть">
                                        <i class="fas fa-eye fa-sm"></i>
                                    </button>
                                    <button type="button" class="btn btn-sm btn-outline-danger rounded-circle delete-review"
                                            data-id="<?= $review->id ?>" title="Удалить">
                                        <i class="fas fa-trash fa-sm"></i>
                                    </button>
                                </div>
                            </td>
                        </tr>
                    <?php endforeach; ?>
                    </tbody>
                </table>
            </div>

            <!-- Пагинация -->
            <?php if ($dataProvider->pagination->pageCount > 1): ?>
            <div class="mt-4 pt-3 border-top">
                <nav aria-label="Пагинация">
                    <?= \yii\widgets\LinkPager::widget([
                        'pagination' => $dataProvider->pagination,
                        'options' => [
                            'class' => 'pagination justify-content-center mb-0',
                        ],
                        'linkContainerOptions' => ['class' => 'page-item'],
                        'linkOptions' => ['class' => 'page-link'],
                        'disabledListItemSubTagOptions' => ['class' => 'page-link'],
                    ]) ?>
                </nav>
            </div>
            <?php endif; ?>
        </div>
    </div>
</div>

<?php
$js = <<<JS
$(document).ready(function() {
    // Просмотр отзыва
    $('.view-review').on('click', function() {
        var id = $(this).data('id');
        
        $.ajax({
            url: '/admin/view-review?id=' + id,
            type: 'GET',
            success: function(data) {
                $('body').append(data);
                var modal = new bootstrap.Modal(document.getElementById('reviewModal'));
                modal.show();
                
                $('#reviewModal').on('hidden.bs.modal', function() {
                    $(this).remove();
                });
            }
        });
    });
    
    // Удаление отзыва
    $('.delete-review').on('click', function() {
        var id = $(this).data('id');
        
        if (confirm('Вы уверены, что хотите удалить этот отзыв?')) {
            $.ajax({
                url: '/admin/delete-review?id=' + id,
                type: 'POST',
                data: {
                    _csrf: yii.getCsrfToken()
                },
                success: function(response) {
                    if (response.success) {
                        location.reload();
                    } else {
                        alert('Ошибка при удалении: ' + response.message);
                    }
                }
            });
        }
    });
});
JS;
$this->registerJs($js);
?>