<?php
/* @var $this yii\web\View */
/* @var $totalApplications int */
/* @var $newApplications int */
/* @var $totalUsers int */
/* @var $upcomingGames int */

use yii\helpers\Html;
use yii\helpers\Url;

$this->title = 'Админ-панель';
$this->params['breadcrumbs'][] = $this->title;
?>

<div class="admin-index">
    <div class="row mb-5">
        <div class="col-12">
            <div class="d-flex align-items-center justify-content-between mb-4">
                <div>
                    <h1 class="h2 mb-2"><?= Html::encode($this->title) ?></h1>
                    <p class="text-muted">Обзор системы управления "Настолка"</p>
                </div>
                <div class="text-end">
                    <span class="badge bg-light text-dark">
                        <i class="fas fa-clock me-1"></i>
                        <?= date('H:i') ?>
                    </span>
                </div>
            </div>
        </div>
    </div>

    <!-- Статистика в новой стилистике -->
    <div class="row mb-5 g-4">
        <div class="col-xl-3 col-lg-6">
            <div class="card border-0 shadow-sm card-hover">
                <div class="card-body p-4">
                    <div class="d-flex justify-content-between align-items-start mb-3">
                        <div>
                            <h6 class="text-uppercase text-muted small mb-1">Всего заявок</h6>
                            <h2 class="mb-0 fw-bold"><?= $totalApplications ?></h2>
                        </div>
                        <div class="icon-circle bg-primary-light text-primary">
                            <i class="fas fa-clipboard-list"></i>
                        </div>
                    </div>
                    <a href="<?= Url::to(['admin/applications']) ?>" class="text-decoration-none small fw-medium text-primary">
                        Просмотреть <i class="fas fa-arrow-right ms-1"></i>
                    </a>
                </div>
            </div>
        </div>

        <div class="col-xl-3 col-lg-6">
            <div class="card border-0 shadow-sm card-hover">
                <div class="card-body p-4">
                    <div class="d-flex justify-content-between align-items-start mb-3">
                        <div>
                            <h6 class="text-uppercase text-muted small mb-1">Новые заявки</h6>
                            <h2 class="mb-0 fw-bold"><?= $newApplications ?></h2>
                        </div>
                        <div class="icon-circle bg-warning-light text-warning">
                            <i class="fas fa-exclamation-circle"></i>
                        </div>
                    </div>
                    <a href="<?= Url::to(['admin/applications']) ?>?status=new" class="text-decoration-none small fw-medium text-warning">
                        Обработать <i class="fas fa-arrow-right ms-1"></i>
                    </a>
                </div>
            </div>
        </div>

        <div class="col-xl-3 col-lg-6">
            <div class="card border-0 shadow-sm card-hover">
                <div class="card-body p-4">
                    <div class="d-flex justify-content-between align-items-start mb-3">
                        <div>
                            <h6 class="text-uppercase text-muted small mb-1">Пользователей</h6>
                            <h2 class="mb-0 fw-bold"><?= $totalUsers ?></h2>
                        </div>
                        <div class="icon-circle bg-success-light text-success">
                            <i class="fas fa-users"></i>
                        </div>
                    </div>
                    <a href="<?= Url::to(['admin/users']) ?>" class="text-decoration-none small fw-medium text-success">
                        Управление <i class="fas fa-arrow-right ms-1"></i>
                    </a>
                </div>
            </div>
        </div>

        <div class="col-xl-3 col-lg-6">
            <div class="card border-0 shadow-sm card-hover">
                <div class="card-body p-4">
                    <div class="d-flex justify-content-between align-items-start mb-3">
                        <div>
                            <h6 class="text-uppercase text-muted small mb-1">Ближайшие игры</h6>
                            <h2 class="mb-0 fw-bold"><?= $upcomingGames ?></h2>
                        </div>
                        <div class="icon-circle bg-info-light text-info">
                            <i class="fas fa-calendar-alt"></i>
                        </div>
                    </div>
                    <a href="<?= Url::to(['admin/schedule']) ?>" class="text-decoration-none small fw-medium text-info">
                        Расписание <i class="fas fa-arrow-right ms-1"></i>
                    </a>
                </div>
            </div>
        </div>
    </div>

    <!-- Быстрые действия в новом дизайне -->
    <div class="row mb-5">
        <div class="col-12">
            <div class="card border-0 shadow-sm">
                <div class="card-header border-0 bg-transparent py-4">
                    <h5 class="mb-0 fw-medium">Быстрые действия</h5>
                </div>
                <div class="card-body pt-0">
                    <div class="row g-3">
                        <div class="col-xl-3 col-lg-6">
                            <a href="<?= Url::to(['admin/applications']) ?>" class="action-card text-decoration-none">
                                <div class="card border shadow-sm h-100 action-card-hover">
                                    <div class="card-body text-center p-4">
                                        <div class="action-icon mb-3">
                                            <i class="fas fa-clipboard-list fa-2x text-primary"></i>
                                        </div>
                                        <h6 class="fw-medium mb-2">Заявки</h6>
                                        <p class="text-muted small mb-0">Управление заявками пользователей</p>
                                    </div>
                                </div>
                            </a>
                        </div>
                        
                        <div class="col-xl-3 col-lg-6">
                            <a href="<?= Url::to(['admin/users']) ?>" class="action-card text-decoration-none">
                                <div class="card border shadow-sm h-100 action-card-hover">
                                    <div class="card-body text-center p-4">
                                        <div class="action-icon mb-3">
                                            <i class="fas fa-users fa-2x text-success"></i>
                                        </div>
                                        <h6 class="fw-medium mb-2">Пользователи</h6>
                                        <p class="text-muted small mb-0">Управление пользователями системы</p>
                                    </div>
                                </div>
                            </a>
                        </div>
                        
                        <div class="col-xl-3 col-lg-6">
                            <a href="<?= Url::to(['admin/schedule']) ?>" class="action-card text-decoration-none">
                                <div class="card border shadow-sm h-100 action-card-hover">
                                    <div class="card-body text-center p-4">
                                        <div class="action-icon mb-3">
                                            <i class="fas fa-calendar-alt fa-2x text-info"></i>
                                        </div>
                                        <h6 class="fw-medium mb-2">Расписание</h6>
                                        <p class="text-muted small mb-0">Управление расписанием игр</p>
                                    </div>
                                </div>
                            </a>
                        </div>
                        
                        <div class="col-xl-3 col-lg-6">
                            <a href="<?= Url::to(['admin/reviews']) ?>" class="action-card text-decoration-none">
                                <div class="card border shadow-sm h-100 action-card-hover">
                                    <div class="card-body text-center p-4">
                                        <div class="action-icon mb-3">
                                            <i class="fas fa-star fa-2x text-warning"></i>
                                        </div>
                                        <h6 class="fw-medium mb-2">Отзывы</h6>
                                        <p class="text-muted small mb-0">Управление отзывами пользователей</p>
                                    </div>
                                </div>
                            </a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Последние заявки в новом дизайне -->
    <div class="row">
        <div class="col-12">
            <div class="card border-0 shadow-sm">
                <div class="card-header border-0 bg-transparent d-flex justify-content-between align-items-center py-4">
                    <h5 class="mb-0 fw-medium">Последние заявки</h5>
                    <a href="<?= Url::to(['admin/applications']) ?>" class="btn btn-sm btn-outline-primary rounded-pill">
                        <i class="fas fa-list me-1"></i> Все заявки
                    </a>
                </div>
                <div class="card-body pt-0">
                    <?php
                    $latestApplications = \app\models\Application::find()
                        ->joinWith(['user'])
                        ->orderBy(['created_at' => SORT_DESC])
                        ->limit(5)
                        ->all();

                    if ($latestApplications): ?>
                        <div class="table-responsive">
                            <table class="table table-hover table-borderless align-middle">
                                <thead class="table-light">
                                <tr>
                                    <th class="small text-uppercase text-muted">ID</th>
                                    <th class="small text-uppercase text-muted">Пользователь</th>
                                    <th class="small text-uppercase text-muted">Игра</th>
                                    <th class="small text-uppercase text-muted">Дата</th>
                                    <th class="small text-uppercase text-muted">Статус</th>
                                    <th class="small text-uppercase text-muted">Действия</th>
                                </tr>
                                </thead>
                                <tbody>
                                <?php foreach ($latestApplications as $app): ?>
                                    <tr class="border-bottom">
                                        <td>
                                            <span class="badge bg-light text-dark">#<?= $app->id ?></span>
                                        </td>
                                        <td>
                                            <div class="d-flex align-items-center">
                                                <div class="avatar-circle-sm bg-light text-muted me-3">
                                                    <i class="fas fa-user fa-sm"></i>
                                                </div>
                                                <div>
                                                    <div class="fw-medium"><?= Html::encode($app->user->full_name) ?></div>
                                                    <small class="text-muted"><?= $app->phone ?></small>
                                                </div>
                                            </div>
                                        </td>
                                        <td>
                                            <div class="fw-medium"><?= Html::encode($app->game_name) ?></div>
                                            <small class="text-muted"><?= $app->game_category ?></small>
                                        </td>
                                        <td>
                                            <div class="fw-medium"><?= Yii::$app->formatter->asDate($app->date) ?></div>
                                            <small class="text-muted"><?= $app->start_time ?></small>
                                        </td>
                                        <td>
                                            <span class="badge rounded-pill bg-<?= $app->status === 'new' ? 'warning' :
                                                ($app->status === 'approved' ? 'success' : 'info') ?>-light text-<?= $app->status === 'new' ? 'warning' :
                                                ($app->status === 'approved' ? 'success' : 'info') ?>">
                                                <?= $app->getStatusLabel() ?>
                                            </span>
                                        </td>
                                        <td>
                                            <div class="btn-group btn-group-sm" role="group">
                                                <a href="<?= Url::to(['admin/update-application', 'id' => $app->id]) ?>" 
                                                   class="btn btn-outline-primary rounded-circle" title="Редактировать">
                                                    <i class="fas fa-edit fa-sm"></i>
                                                </a>
                                                <button type="button" class="btn btn-outline-info rounded-circle view-details" 
                                                        data-id="<?= $app->id ?>" title="Подробнее">
                                                    <i class="fas fa-eye fa-sm"></i>
                                                </button>
                                            </div>
                                        </td>
                                    </tr>
                                <?php endforeach; ?>
                                </tbody>
                            </table>
                        </div>
                    <?php else: ?>
                        <div class="text-center py-5">
                            <div class="empty-state">
                                <i class="fas fa-clipboard-list fa-3x text-light mb-3"></i>
                                <p class="text-muted mb-0">Заявок пока нет</p>
                            </div>
                        </div>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>
</div>
<style>/* Современные стили для админ-панели */

/* Круглые иконки для карточек */
.icon-circle {
    width: 48px;
    height: 48px;
    border-radius: 12px;
    display: flex;
    align-items: center;
    justify-content: center;
    font-size: 1.25rem;
}

.bg-primary-light { background-color: rgba(13, 110, 253, 0.1); }
.bg-success-light { background-color: rgba(25, 135, 84, 0.1); }
.bg-warning-light { background-color: rgba(255, 193, 7, 0.1); }
.bg-info-light { background-color: rgba(13, 202, 240, 0.1); }
.bg-danger-light { background-color: rgba(220, 53, 69, 0.1); }

/* Эффект при наведении на карточки */
.card-hover {
    transition: all 0.3s ease;
    border: 1px solid #f0f0f0;
}

.card-hover:hover {
    transform: translateY(-4px);
    box-shadow: 0 8px 25px rgba(0, 0, 0, 0.1) !important;
    border-color: #e0e0e0;
}

.action-card-hover {
    transition: all 0.3s ease;
    border: 1px solid #f8f9fa;
}

.action-card-hover:hover {
    transform: translateY(-3px);
    box-shadow: 0 4px 15px rgba(0, 0, 0, 0.08) !important;
    border-color: #dee2e6;
}

/* Стили для таблиц */
.table-borderless td, .table-borderless th {
    border: none;
}

.table-borderless tbody tr:not(:last-child) {
    border-bottom: 1px solid #f0f0f0;
}

/* Круглый аватар */
.avatar-circle-sm {
    width: 36px;
    height: 36px;
    border-radius: 50%;
    display: flex;
    align-items: center;
    justify-content: center;
    font-size: 0.875rem;
}

/* Стили для пустых состояний */
.empty-state {
    color: #adb5bd;
}

.empty-state i {
    color: #e9ecef;
}

/* Стили для иконок действий */
.action-icon {
    width: 64px;
    height: 64px;
    margin: 0 auto;
    border-radius: 16px;
    display: flex;
    align-items: center;
    justify-content: center;
    background: #f8f9fa;
}

/* Улучшенные бейджи */
.badge {
    padding: 0.35em 0.65em;
    font-weight: 500;
}

/* Стили для модальных окон */
.modal-content {
    border: none;
    box-shadow: 0 10px 40px rgba(0, 0, 0, 0.1);
    border-radius: 12px;
}

.modal-header {
    border-bottom: 1px solid #f0f0f0;
    padding: 1.5rem 1.5rem 1rem;
}

.modal-body {
    padding: 1.5rem;
}

.modal-footer {
    border-top: 1px solid #f0f0f0;
    padding: 1rem 1.5rem 1.5rem;
}

/* Улучшенные формы */
.form-control, .form-select {
    border: 1px solid #e0e0e0;
    border-radius: 8px;
    padding: 0.625rem 0.75rem;
}

.form-control:focus, .form-select:focus {
    border-color: #86b7fe;
    box-shadow: 0 0 0 0.25rem rgba(13, 110, 253, 0.1);
}

/* Кнопки в новом стиле */
.btn {
    border-radius: 8px;
    font-weight: 500;
    padding: 0.5rem 1rem;
}

.btn-sm {
    padding: 0.25rem 0.5rem;
    border-radius: 6px;
}

.btn-lg {
    padding: 0.75rem 1.5rem;
    border-radius: 10px;
}

.btn-outline-primary, .btn-outline-success, 
.btn-outline-warning, .btn-outline-info, 
.btn-outline-danger {
    border-width: 1px;
}

/* Стили для карточек */
.card {
    border: none;
    box-shadow: 0 2px 10px rgba(0, 0, 0, 0.05);
    border-radius: 12px;
}

.card-header {
    border-bottom: 1px solid #f0f0f0;
}

/* Пагинация */
.pagination .page-link {
    border: none;
    border-radius: 6px;
    margin: 0 3px;
    color: #495057;
}

.pagination .page-link:hover {
    background-color: #f8f9fa;
}

.pagination .page-item.active .page-link {
    background-color: #0d6efd;
    color: white;
}

/* Улучшенные бейджи статусов */
.badge-rounded {
    border-radius: 10px;
    padding: 0.25em 0.75em;
    font-weight: 500;
}</style>