
<style>
.card {
  border-radius: 12px;
  transition: transform .2s ease, box-shadow .2s ease;
}
.card:hover {
  transform: translateY(-4px);
  box-shadow: 0 12px 30px rgba(0,0,0,.15);
}
.btn {
  transition: all .2s ease;
}
.btn:hover {
  transform: translateY(-1px);
}
.table-hover tbody tr {
  transition: background-color .15s ease;
}
.fade-in {
  animation: fadeIn .4s ease-in-out;
}
@keyframes fadeIn {
  from {opacity:0; transform: translateY(6px);}
  to {opacity:1; transform:none;}
}
</style>

<div class="container my-4">
<div class="card shadow-sm fade-in">
<div class="card-body">
<?php

/* @var $this yii\web\View */
/* @var $model app\models\Schedule */

use yii\helpers\Html;
use yii\widgets\ActiveForm;
use yii\helpers\Url;

$this->title = 'Добавить игру в расписание';
$this->params['breadcrumbs'][] = ['label' => 'Управление расписанием', 'url' => ['schedule']];
$this->params['breadcrumbs'][] = $this->title;
?>

<div class="admin-create-schedule">
    <div class="row">
        <div class="col-lg-8">
            <div class="card">
                <div class="card-header bg-primary text-white">
                    <h3 class="mb-0"><?= Html::encode($this->title) ?></h3>
                </div>
                <div class="card-body">
                    <?php $form = ActiveForm::begin(); ?>

                    <div class="row">
                        <div class="col-md-6">
                            <?= $form->field($model, 'game_id')->dropDownList(
                                \yii\helpers\ArrayHelper::map(
                                    \app\models\Game::find()->all(),
                                    'id',
                                    function($game) {
                                        return $game->name . ' (' . $game->getCategoryLabel() . ')';
                                    }
                                ),
                                [
                                    'prompt' => 'Выберите игру',
                                    'class' => 'form-select'
                                ]
                            )->label('Игра') ?>
                        </div>

                        <div class="col-md-6">
                            <?= $form->field($model, 'date')->textInput([
                                'type' => 'date',
                                'class' => 'form-control',
                                'value' => date('Y-m-d')
                            ]) ?>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-md-6">
                            <?= $form->field($model, 'start_time')->textInput([
                                'type' => 'time',
                                'class' => 'form-control',
                                'value' => '19:00'
                            ]) ?>
                        </div>

                        <div class="col-md-6">
                            <?= $form->field($model, 'price')->textInput([
                                'type' => 'number',
                                'step' => '0.01',
                                'class' => 'form-control',
                                'value' => '1000'
                            ]) ?>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-md-6">
                            <?= $form->field($model, 'max_players')->textInput([
                                'type' => 'number',
                                'min' => 1,
                                'class' => 'form-control',
                                'value' => '10'
                            ]) ?>
                        </div>

                        <div class="col-md-6">
                            <?= $form->field($model, 'current_players')->textInput([
                                'type' => 'number',
                                'min' => 0,
                                'class' => 'form-control',
                                'value' => '0'
                            ]) ?>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-12">
                            <?= $form->field($model, 'address')->textInput([
                                'class' => 'form-control',
                                'placeholder' => 'Например: г. Москва, ул. Примерная, д. 10',
                                'value' => 'г. Москва, ул. Примерная, д. 10'
                            ]) ?>
                        </div>
                    </div>

                    <div class="form-group mt-4">
                        <?= Html::submitButton('Добавить в расписание', ['class' => 'btn btn-success btn-lg btn-lg']) ?>
                        <?= Html::a('Отмена', ['schedule'], ['class' => 'btn btn-outline-secondary btn-lg ms-2']) ?>
                    </div>

                    <?php ActiveForm::end(); ?>
                </div>
            </div>
        </div>

        <div class="col-lg-4">
            <div class="card">
                <div class="card-header bg-info text-white">
                    <h5 class="mb-0">Подсказки</h5>
                </div>
                <div class="card-body">
                    <div class="alert alert-info">
                        <i class="fas fa-lightbulb me-2"></i>
                        <strong>Совет:</strong> Добавляйте игры минимум за 3 дня до даты проведения.
                    </div>

                    <ul class="list-unstyled">
                        <li class="mb-2">
                            <i class="fas fa-check-circle text-success me-2"></i>
                            Оптимальное время начала: 19:00
                        </li>
                        <li class="mb-2">
                            <i class="fas fa-check-circle text-success me-2"></i>
                            Оптимальное количество игроков: 6-12
                        </li>
                        <li class="mb-2">
                            <i class="fas fa-check-circle text-success me-2"></i>
                            Средняя стоимость: 1000-2000 руб.
                        </li>
                        <li>
                            <i class="fas fa-check-circle text-success me-2"></i>
                            Пятница и суббота - самые популярные дни
                        </li>
                    </ul>
                </div>
            </div>
        </div>
    </div>
</div>
</div>
</div>
</div>