<?php
/* @var $this yii\web\View */
/* @var $dataProvider yii\data\ActiveDataProvider */

use yii\helpers\Html;
use yii\helpers\Url;
use yii\widgets\ListView;
use yii\widgets\Pjax;

$this->title = 'Управление заявками';
$this->params['breadcrumbs'][] = $this->title;
?>

<div class="admin-applications">
    <!-- Хедер страницы -->
    <div class="row mb-4">
        <div class="col-12">
            <div class="d-flex align-items-center justify-content-between mb-4">
                <div>
                    <h1 class="h2 mb-2"><?= Html::encode($this->title) ?></h1>
                    <p class="text-muted">Управление всеми заявками пользователей</p>
                </div>
                <div class="text-end">
                    <span class="badge bg-primary-light text-primary">
                        <i class="fas fa-clipboard-list me-1"></i>
                        Всего: <?= $dataProvider->getTotalCount() ?>
                    </span>
                </div>
            </div>
        </div>
    </div>

    <!-- Карточки статистики -->
    <div class="row g-4 mb-4">
        <div class="col-xl-3 col-lg-6">
            <div class="card border-0 shadow-sm">
                <div class="card-body p-4">
                    <div class="d-flex align-items-center">
                        <div class="icon-circle bg-warning-light text-warning me-3">
                            <i class="fas fa-clock"></i>
                        </div>
                        <div>
                            <div class="text-muted small mb-1">Новые заявки</div>
                            <div class="h4 mb-0"><?= \app\models\Application::find()->where(['status' => 'new'])->count() ?></div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-xl-3 col-lg-6">
            <div class="card border-0 shadow-sm">
                <div class="card-body p-4">
                    <div class="d-flex align-items-center">
                        <div class="icon-circle bg-success-light text-success me-3">
                            <i class="fas fa-check-circle"></i>
                        </div>
                        <div>
                            <div class="text-muted small mb-1">Одобренные</div>
                            <div class="h4 mb-0"><?= \app\models\Application::find()->where(['status' => 'approved'])->count() ?></div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-xl-3 col-lg-6">
            <div class="card border-0 shadow-sm">
                <div class="card-body p-4">
                    <div class="d-flex align-items-center">
                        <div class="icon-circle bg-info-light text-info me-3">
                            <i class="fas fa-flag-checkered"></i>
                        </div>
                        <div>
                            <div class="text-muted small mb-1">Завершенные</div>
                            <div class="h4 mb-0"><?= \app\models\Application::find()->where(['status' => 'completed'])->count() ?></div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-xl-3 col-lg-6">
            <div class="card border-0 shadow-sm">
                <div class="card-body p-4">
                    <div class="d-flex align-items-center">
                        <div class="icon-circle bg-primary-light text-primary me-3">
                            <i class="fas fa-chart-line"></i>
                        </div>
                        <div>
                            <div class="text-muted small mb-1">За месяц</div>
                            <div class="h4 mb-0"><?= \app\models\Application::find()
                                ->where(['>=', 'created_at', date('Y-m-01')])
                                ->count() ?></div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Фильтры -->
    <div class="card border-0 shadow-sm mb-4">
        <div class="card-body p-4">
            <div class="row g-3">
                <div class="col-lg-4">
                    <div class="input-group">
                        <span class="input-group-text bg-light border-end-0">
                            <i class="fas fa-search text-muted"></i>
                        </span>
                        <input type="text" id="search-input" class="form-control border-start-0 ps-0" 
                               placeholder="Поиск по имени, игре или телефону...">
                    </div>
                </div>
                <div class="col-lg-3">
                    <select class="form-select" id="status-filter">
                        <option value="">Все статусы</option>
                        <option value="new">Новые</option>
                        <option value="approved">Одобренные</option>
                        <option value="completed">Завершенные</option>
                    </select>
                </div>
                <div class="col-lg-3">
                    <input type="date" class="form-control" id="date-filter" 
                           value="<?= date('Y-m-d') ?>">
                </div>
                <div class="col-lg-2">
                    <button class="btn btn-outline-secondary w-100 rounded-pill" id="filter-reset">
                        <i class="fas fa-redo me-1"></i> Сбросить
                    </button>
                </div>
            </div>
        </div>
    </div>

    <!-- Таблица заявок -->
    <div class="card border-0 shadow-sm">
        <div class="card-header border-0 bg-transparent d-flex justify-content-between align-items-center py-4">
            <h5 class="mb-0 fw-medium">Список заявок</h5>
            <div class="d-flex gap-2">
                <button class="btn btn-sm btn-outline-primary rounded-pill" id="export-btn">
                    <i class="fas fa-download me-1"></i> Экспорт
                </button>
                <button class="btn btn-sm btn-outline-success rounded-pill" id="refresh-btn">
                    <i class="fas fa-sync-alt me-1"></i> Обновить
                </button>
            </div>
        </div>
        <div class="card-body pt-0">
            <?php Pjax::begin(['id' => 'applications-pjax']); ?>
            
            <div class="table-responsive">
                <table class="table table-hover table-borderless align-middle mb-0">
                    <thead class="table-light">
                    <tr>
                        <th class="small text-uppercase text-muted" width="80">ID</th>
                        <th class="small text-uppercase text-muted">Пользователь</th>
                        <th class="small text-uppercase text-muted">Игра</th>
                        <th class="small text-uppercase text-muted" width="140">Дата игры</th>
                        <th class="small text-uppercase text-muted" width="120">Статус</th>
                        <th class="small text-uppercase text-muted" width="140">Создана</th>
                        <th class="small text-uppercase text-muted text-end" width="120">Действия</th>
                    </tr>
                    </thead>
                    <tbody>
                    <?= ListView::widget([
                        'dataProvider' => $dataProvider,
                        'itemView' => '_application_item',
                        'layout' => "{items}",
                        'emptyText' => '<tr>
                            <td colspan="7" class="text-center py-5">
                                <div class="empty-state">
                                    <i class="fas fa-clipboard-list fa-3x text-light mb-3"></i>
                                    <p class="text-muted mb-0">Заявок не найдено</p>
                                    <small class="text-muted">Попробуйте изменить параметры поиска</small>
                                </div>
                            </td>
                        </tr>',
                    ]); ?>
                    </tbody>
                </table>
            </div>

            <!-- Пагинация -->
            <?php if ($dataProvider->pagination->pageCount > 1): ?>
            <div class="mt-4 pt-3 border-top">
                <div class="d-flex justify-content-between align-items-center">
                    <div class="text-muted small">
                        Показано <?= $dataProvider->getCount() ?> из <?= $dataProvider->getTotalCount() ?> заявок
                    </div>
                    <nav aria-label="Пагинация">
                        <?= \yii\widgets\LinkPager::widget([
                            'pagination' => $dataProvider->pagination,
                            'options' => [
                                'class' => 'pagination justify-content-center mb-0',
                            ],
                            'linkContainerOptions' => ['class' => 'page-item'],
                            'linkOptions' => ['class' => 'page-link rounded'],
                            'disabledListItemSubTagOptions' => ['class' => 'page-link rounded'],
                        ]) ?>
                    </nav>
                </div>
            </div>
            <?php endif; ?>
            
            <?php Pjax::end(); ?>
        </div>
    </div>
</div>

<?php
$js = <<<JS
$(document).ready(function() {
    // Поиск
    $('#search-input').on('keyup', function() {
        $.pjax.reload({
            container: '#applications-pjax',
            data: {search: $(this).val()},
            timeout: 1000
        });
    });
    
    // Фильтр по статусу
    $('#status-filter').on('change', function() {
        $.pjax.reload({
            container: '#applications-pjax',
            data: {status: $(this).val()},
            timeout: 1000
        });
    });
    
    // Фильтр по дате
    $('#date-filter').on('change', function() {
        $.pjax.reload({
            container: '#applications-pjax',
            data: {date: $(this).val()},
            timeout: 1000
        });
    });
    
    // Сброс фильтров
    $('#filter-reset').on('click', function() {
        $('#search-input').val('');
        $('#status-filter').val('');
        $('#date-filter').val('');
        
        $.pjax.reload({
            container: '#applications-pjax',
            data: {},
            timeout: 1000
        });
    });
    
    // Обновление
    $('#refresh-btn').on('click', function() {
        $.pjax.reload({
            container: '#applications-pjax',
            timeout: 1000
        });
    });
    
    // Экспорт
    $('#export-btn').on('click', function() {
        window.location.href = '/admin/export-applications?' + $.param({
            search: $('#search-input').val(),
            status: $('#status-filter').val(),
            date: $('#date-filter').val()
        });
    });
});
JS;
$this->registerJs($js);
?>