<?php

namespace app\models;

use Yii;
use yii\db\ActiveRecord;

/**
 * @property int $id
 * @property int $user_id
 * @property int $application_id
 * @property int $rating
 * @property string $comment
 * @property string $created_at
 *
 * @property User $user
 * @property Application $application
 */
class Review extends ActiveRecord
{
    public static function tableName()
    {
        return '{{%reviews}}';
    }

    public function rules()
    {
        return [
            [['user_id', 'rating', 'comment'], 'required'],
            [['user_id', 'application_id', 'rating'], 'integer'],
            ['rating', 'integer', 'min' => 1, 'max' => 5],
            [['comment'], 'string'],
            [['user_id'], 'exist', 'skipOnError' => true, 'targetClass' => User::class, 'targetAttribute' => ['user_id' => 'id']],
            [['application_id'], 'exist', 'skipOnError' => true, 'targetClass' => Application::class, 'targetAttribute' => ['application_id' => 'id']],
        ];
    }

    public function getUser()
    {
        return $this->hasOne(User::class, ['id' => 'user_id']);
    }

    public function getApplication()
    {
        return $this->hasOne(Application::class, ['id' => 'application_id']);
    }
}