<?php

use yii\db\Migration;

/**
 * Handles the creation of table `{{%reviews}}`.
 */
class m251221_054545_create_reviews_table extends Migration
{
    /**
     * {@inheritdoc}
     */
    public function safeUp()
    {
        $this->createTable('{{%reviews}}', [
            'id' => $this->primaryKey(),
            'user_id' => $this->integer()->notNull(),
            'application_id' => $this->integer(),
            'rating' => $this->integer()->notNull()->check('rating >= 1 AND rating <= 5'),
            'comment' => $this->text()->notNull(),
            'created_at' => $this->timestamp()->defaultExpression('CURRENT_TIMESTAMP'),
        ]);

        $this->addForeignKey(
            'fk-reviews-user_id',
            '{{%reviews}}',
            'user_id',
            '{{%users}}',
            'id',
            'CASCADE'
        );

        $this->addForeignKey(
            'fk-reviews-application_id',
            '{{%reviews}}',
            'application_id',
            '{{%applications}}',
            'id',
            'SET NULL'
        );

        // Добавляем тестовые отзывы
        $reviews = [
            [1, 'Отличная организация игр! Все понравилось.', 5],
            [1, 'Интересные игры, веселые компании.', 4],
            [1, 'Буду рекомендовать друзьям!', 5],
            [1, 'Отличное место для проведения времени.', 4],
        ];

        foreach ($reviews as $review) {
            $this->insert('{{%reviews}}', [
                'user_id' => 1, // Администратор (от имени клиентов)
                'rating' => $review[2],
                'comment' => $review[1],
            ]);
        }
    }

    /**
     * {@inheritdoc}
     */
    public function safeDown()
    {
        $this->dropForeignKey('fk-reviews-user_id', '{{%reviews}}');
        $this->dropForeignKey('fk-reviews-application_id', '{{%reviews}}');
        $this->dropTable('{{%reviews}}');
    }
}
