<?php

use yii\db\Migration;

/**
 * Handles the creation of table `{{%games}}`.
 */
class m251221_054242_create_games_table extends Migration
{
    /**
     * {@inheritdoc}
     */
    public function safeUp()
    {
        $this->createTable('{{%games}}', [
            'id' => $this->primaryKey(),
            'category' => $this->string(50)->notNull()->comment('Вид игры: classic, card, economic, strategy, children'),
            'name' => $this->string(100)->notNull(),
            'description' => $this->text(),
            'image' => $this->string(255),
            'is_popular' => $this->boolean()->defaultValue(false),
            'created_at' => $this->timestamp()->defaultExpression('CURRENT_TIMESTAMP'),
        ]);

        $games = [
            // Классические
            ['classic', 'Шахматы'],
            ['classic', 'Шашки'],
            ['classic', 'Нарды'],
            ['classic', 'Домино'],

            // Карточные
            ['card', 'Шакал'],
            ['card', 'Тако, кот, коза, сыр, пицца'],
            ['card', 'Взрывные котята'],
            ['card', 'Свинтус'],
            ['card', 'Мафия'],
            ['card', 'Бункер'],
            ['card', 'Сопротивление'],

            // Экономические
            ['economic', 'Монополия'],
            ['economic', 'Крысиные бега'],
            ['economic', 'Маракайбо'],

            // Стратегии
            ['strategy', 'Каркассон'],
            ['strategy', 'Шакал'],
            ['strategy', 'Почта'],
            ['strategy', 'Улей'],
            ['strategy', 'Битва за Рокуган'],
            ['strategy', 'Иван Грозный: Первый царь'],

            // Для детей
            ['children', 'Кубопрыги'],
            ['children', 'Фотовечеринка'],
            ['children', 'Средневековая академия'],
        ];

        foreach ($games as $game) {
            $this->insert('{{%games}}', [
                'category' => $game[0],
                'name' => $game[1],
                'is_popular' => in_array($game[1], ['Шакал', 'Монополия', 'Каркассон', 'Мафия']),
            ]);
        }
    }


    /**
     * {@inheritdoc}
     */
    public function safeDown()
    {
        $this->dropTable('{{%games}}');
    }
}
