<?php

use yii\db\Migration;

/**
 * Handles the creation of table `{{%users}}`.
 */
class m251221_054149_create_users_table extends Migration
{
    /**
     * {@inheritdoc}
     */
    public function safeUp()
    {
        $this->createTable('{{%users}}', [
            'id' => $this->primaryKey(),
            'full_name' => $this->string(255)->notNull(),
            'phone' => $this->string(20)->notNull()->unique(),
            'email' => $this->string(255)->notNull()->unique(),
            'password_hash' => $this->string(255)->notNull(),
            'auth_key' => $this->string(32),
            'access_token' => $this->string(255),
            'status' => $this->smallInteger()->defaultValue(10),
            'created_at' => $this->timestamp()->defaultExpression('CURRENT_TIMESTAMP'),
            'updated_at' => $this->timestamp()->defaultExpression('CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP'),
        ]);

        // Добавляем администратора
        $this->insert('{{%users}}', [
            'full_name' => 'Администратор',
            'phone' => '89999999999',
            'email' => 'admin@nastolka.ru',
            'password_hash' => Yii::$app->security->generatePasswordHash('organizator'),
            'auth_key' => Yii::$app->security->generateRandomString(),
            'status' => 10,
        ]);
    }

    /**
     * {@inheritdoc}
     */
    public function safeDown()
    {
        $this->dropTable('{{%users}}');
    }
}
